/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid;

import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LSID {
    private String lsid;
    private LSIDAuthority authority;
    private String namespace;
    private String object;
    private String revision;
    private LSID abstr;
    private String format;
    private String type;
    private LSID[] instances;

    public LSID(String lsid) throws MalformedLSIDException {
        if (lsid.endsWith(":")) {
            lsid = lsid.substring(0, lsid.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(lsid, ":");
        try {
            String urn = st.nextToken().toLowerCase();
            String l = st.nextToken().toLowerCase();
            if (!urn.equals("urn") || !l.equals("lsid")) {
                throw new MalformedLSIDException("urn:lsid: not found: [" + lsid + "]");
            }
        }
        catch (NoSuchElementException e) {
            throw new MalformedLSIDException(e, "urn:lsid: not found: [" + lsid + "]");
        }
        try {
            this.authority = new LSIDAuthority(st.nextToken().toLowerCase());
        }
        catch (MalformedLSIDException e) {
            throw new MalformedLSIDException(e, "invalid authority found: [" + lsid + "]");
        }
        catch (NoSuchElementException e) {
            throw new MalformedLSIDException(e, "authority not found: [" + lsid + "]");
        }
        try {
            this.namespace = st.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new MalformedLSIDException(e, "namespace not found: [" + lsid + "]");
        }
        try {
            this.object = st.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new MalformedLSIDException(e, "object not found: [" + lsid + "]");
        }
        if (st.hasMoreTokens()) {
            this.revision = st.nextToken();
        }
        this.lsid = "urn:lsid:" + this.authority + ":" + this.namespace + ":" + this.object + (this.revision != null ? ":" + this.revision : "");
    }

    public LSID(String authority, String namespace, String object, String revision) throws MalformedLSIDException {
        this.authority = new LSIDAuthority(authority.toLowerCase());
        this.namespace = namespace;
        this.object = object;
        if (revision != null) {
            this.revision = revision;
        }
        this.lsid = "urn:lsid:" + this.authority + ":" + this.namespace + ":" + this.object + (this.revision != null ? ":" + this.revision : "");
    }

    public String getLsid() {
        return this.lsid;
    }

    public LSIDAuthority getAuthority() {
        return this.authority;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getObject() {
        return this.object;
    }

    public String getRevision() {
        return this.revision;
    }

    public String toString() {
        return this.lsid;
    }

    public boolean equals(Object lsid) {
        if (lsid instanceof LSID) {
            LSID theLSID = (LSID)lsid;
            return theLSID.toString().equals(this.toString());
        }
        return false;
    }

    public LSID getAbstr() {
        return this.abstr;
    }

    public String getFormat() {
        return this.format;
    }

    public LSID[] getInstances() {
        return this.instances;
    }

    public String getType() {
        return this.type;
    }

    public void setAbstr(LSID abstr) {
        this.abstr = abstr;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setInstances(LSID[] instances) {
        this.instances = instances;
    }

    public void setType(String type) {
        this.type = type;
    }
}

