/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public final class Lookup {
    private static Resolver defaultResolver;
    private static Name[] defaultSearchPath;
    private static Map defaultCaches;
    private Resolver resolver;
    private Name[] searchPath;
    private Cache cache;
    private byte credibility;
    private Name name;
    private short type;
    private short dclass;
    private boolean verbose;
    private int iterations;
    private boolean found;
    private boolean done;
    private List aliases;
    private Record[] answers;
    private int result;
    private String error;
    private boolean nxdomain;
    private boolean badresponse;
    private boolean networkerror;
    private boolean nametoolong;
    public static final int SUCCESSFUL = 0;
    public static final int UNRECOVERABLE = 1;
    public static final int TRY_AGAIN = 2;
    public static final int HOST_NOT_FOUND = 3;
    public static final int TYPE_NOT_FOUND = 4;
    static /* synthetic */ Class class$org$xbill$DNS$Lookup;

    public static synchronized Resolver getDefaultResolver() {
        return defaultResolver;
    }

    public static synchronized void setDefaultResolver(Resolver resolver) {
        defaultResolver = resolver;
    }

    public static synchronized Cache getDefaultCache(short dclass) {
        Cache c = (Cache)defaultCaches.get(DClass.toShort(dclass));
        if (c == null) {
            c = new Cache(dclass);
            defaultCaches.put(DClass.toShort(dclass), c);
        }
        return c;
    }

    public static synchronized void setDefaultCache(Cache cache, short dclass) {
        defaultCaches.put(DClass.toShort(dclass), cache);
    }

    public static synchronized Name[] getDefaultSearchPath() {
        return defaultSearchPath;
    }

    public static synchronized void setDefaultSearchPath(Name[] domains) {
        defaultSearchPath = domains;
    }

    public static synchronized void setDefaultSearchPath(String[] domains) throws TextParseException {
        if (domains == null) {
            defaultSearchPath = null;
            return;
        }
        Name[] newdomains = new Name[domains.length];
        int i = 0;
        while (i < domains.length) {
            newdomains[i] = Name.fromString(domains[i], Name.root);
            ++i;
        }
        defaultSearchPath = newdomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup(Name name, short type, short dclass) {
        if (!Type.isRR(type) && type != 255) {
            throw new IllegalArgumentException("Cannot query for meta-types other than ANY");
        }
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        Class clazz = class$org$xbill$DNS$Lookup == null ? (class$org$xbill$DNS$Lookup = Lookup.class$("org.xbill.DNS.Lookup")) : class$org$xbill$DNS$Lookup;
        synchronized (clazz) {
            this.resolver = defaultResolver;
            this.searchPath = defaultSearchPath;
            this.cache = Lookup.getDefaultCache(dclass);
        }
        this.credibility = (byte)3;
        this.verbose = Options.check("verbose");
        this.result = -1;
        this.aliases = new ArrayList();
    }

    public Lookup(Name name, short type) {
        this(name, type, 1);
    }

    public Lookup(Name name) {
        this(name, 1, 1);
    }

    public Lookup(String name, short type, short dclass) throws TextParseException {
        this(Name.fromString(name), type, dclass);
    }

    public Lookup(String name, short type) throws TextParseException {
        this(Name.fromString(name), type, 1);
    }

    public Lookup(String name) throws TextParseException {
        this(Name.fromString(name), 1, 1);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public void setSearchPath(Name[] domains) {
        this.searchPath = domains;
    }

    public void setSearchPath(String[] domains) throws TextParseException {
        if (domains == null) {
            this.searchPath = null;
            return;
        }
        Name[] newdomains = new Name[domains.length];
        int i = 0;
        while (i < domains.length) {
            newdomains[i] = Name.fromString(domains[i], Name.root);
            ++i;
        }
        this.searchPath = newdomains;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setCredibility(byte credibility) {
        this.credibility = credibility;
    }

    private void follow(Name name, Name oldname) {
        this.found = true;
        this.badresponse = false;
        this.networkerror = false;
        this.nxdomain = false;
        ++this.iterations;
        if (this.iterations >= 6 || name.equals(oldname)) {
            this.result = 1;
            this.error = "CNAME loop";
            return;
        }
        this.aliases.add(name);
        this.lookup(name);
    }

    private void processResponse(Name name, SetResponse response) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (!response.isSuccessful()) break block4;
                            RRset[] rrsets = response.answers();
                            ArrayList l = new ArrayList();
                            int i = 0;
                            while (i < rrsets.length) {
                                Iterator it = rrsets[i].rrs();
                                while (it.hasNext()) {
                                    l.add(it.next());
                                }
                                ++i;
                            }
                            this.result = 0;
                            this.answers = l.toArray(new Record[l.size()]);
                            this.done = true;
                            break block5;
                        }
                        if (!response.isNXDOMAIN()) break block6;
                        this.nxdomain = true;
                        break block5;
                    }
                    if (!response.isNXRRSET()) break block7;
                    this.result = 4;
                    this.answers = null;
                    this.done = true;
                    break block5;
                }
                if (!response.isCNAME()) break block8;
                CNAMERecord cname = response.getCNAME();
                this.follow(cname.getTarget(), name);
                break block5;
            }
            if (!response.isDNAME()) break block5;
            DNAMERecord dname = response.getDNAME();
            Object newname = null;
            try {
                this.follow(name.fromDNAME(dname), name);
            }
            catch (NameTooLongException e) {
                this.result = 1;
                this.error = "Invalid DNAME target";
                this.done = true;
            }
        }
    }

    private void lookup(Name current) {
        SetResponse sr = this.cache.lookupRecords(current, this.type, this.credibility);
        if (this.verbose) {
            System.err.println("lookup " + current + " " + Type.string(this.type));
            System.err.println(sr);
        }
        this.processResponse(current, sr);
        if (this.done) {
            return;
        }
        Record question = Record.newRecord(current, this.type, this.dclass);
        Message query = Message.newQuery(question);
        Message response = null;
        try {
            response = this.resolver.send(query);
        }
        catch (IOException e) {
            this.networkerror = true;
            return;
        }
        short rcode = response.getHeader().getRcode();
        if (rcode != 0 && rcode != 3) {
            this.badresponse = true;
            return;
        }
        sr = this.cache.addMessage(response);
        if (sr == null) {
            sr = this.cache.lookupRecords(current, this.type, this.credibility);
        }
        if (this.verbose) {
            System.err.println("queried " + current + " " + Type.string(this.type));
            System.err.println(sr);
        }
        this.processResponse(current, sr);
    }

    private void resolve(Name current, Name suffix) {
        Name tname = null;
        if (suffix == null) {
            tname = current;
        } else {
            try {
                tname = Name.concatenate(current, suffix);
            }
            catch (NameTooLongException e) {
                this.nametoolong = true;
                return;
            }
        }
        this.lookup(tname);
        if (this.found) {
            this.done = true;
        }
    }

    public Record[] run() {
        if (this.name.isAbsolute()) {
            this.resolve(this.name, null);
        } else if (this.searchPath == null) {
            this.resolve(this.name, Name.root);
        } else {
            if (this.name.labels() > 1) {
                this.resolve(this.name, Name.root);
            }
            if (this.done) {
                return this.answers;
            }
            int i = 0;
            while (i < this.searchPath.length) {
                this.resolve(this.name, this.searchPath[i]);
                if (this.done) {
                    return this.answers;
                }
                ++i;
            }
            if (this.name.labels() <= 1) {
                this.resolve(this.name, Name.root);
            }
        }
        if (!this.done) {
            if (this.badresponse) {
                this.result = 1;
                this.error = "bad response";
                this.done = true;
            } else if (this.networkerror) {
                this.result = 2;
                this.error = "network error";
                this.done = true;
            } else if (this.nxdomain) {
                this.result = 3;
                this.done = true;
            } else if (this.nametoolong) {
                this.result = 1;
                this.error = "name too long";
                this.done = true;
            }
        }
        return this.answers;
    }

    public Record[] getAnswers() {
        if (!this.done || this.result == -1) {
            throw new IllegalStateException("Lookup isn't done");
        }
        return this.answers;
    }

    public Name[] getAliases() {
        if (!this.done || this.result == -1) {
            throw new IllegalStateException("Lookup isn't done");
        }
        return this.aliases.toArray(new Name[this.aliases.size()]);
    }

    public int getResult() {
        if (!this.done || this.result == -1) {
            throw new IllegalStateException("Lookup isn't done");
        }
        return this.result;
    }

    public String getErrorString() {
        if (!this.done || this.result == -1) {
            throw new IllegalStateException("Lookup isn't done");
        }
        if (this.error != null) {
            return this.error;
        }
        switch (this.result) {
            case 0: {
                return "successful";
            }
            case 1: {
                return "unrecoverable error";
            }
            case 2: {
                return "try again";
            }
            case 3: {
                return "host not found";
            }
            case 4: {
                return "type not found";
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            defaultResolver = new ExtendedResolver();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to initialize resolver");
        }
        defaultSearchPath = FindServer.searchPath();
        defaultCaches = new HashMap();
    }
}

