/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.BitSet;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class NXTRecord
extends Record {
    private static NXTRecord member = new NXTRecord();
    private Name next;
    private BitSet bitmap;

    private NXTRecord() {
    }

    private NXTRecord(Name name, short dclass, int ttl) {
        super(name, (short)30, dclass, ttl);
    }

    static NXTRecord getMember() {
        return member;
    }

    public NXTRecord(Name name, short dclass, int ttl, Name next, BitSet bitmap) {
        this(name, dclass, ttl);
        this.next = next;
        this.bitmap = bitmap;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        NXTRecord rec = new NXTRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        int start = in.getPos();
        rec.next = new Name(in);
        rec.bitmap = new BitSet();
        int bitmapLength = length - (in.getPos() - start);
        int i = 0;
        while (i < bitmapLength) {
            int t = in.readUnsignedByte();
            int j = 0;
            while (j < 8) {
                if ((t & 1 << 7 - j) != 0) {
                    rec.bitmap.set(i * 8 + j);
                }
                ++j;
            }
            ++i;
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        NXTRecord rec = new NXTRecord(name, dclass, ttl);
        rec.next = Name.fromString(st.nextToken(), origin);
        rec.bitmap = new BitSet();
        while (st.hasMoreTokens()) {
            short t = Type.value(st.nextToken());
            if (t <= 0) continue;
            rec.bitmap.set(t);
        }
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.next != null) {
            sb.append(this.next);
            short s = this.BitSetLength(this.bitmap);
            short i = 0;
            while (i < s) {
                if (this.bitmap.get(i)) {
                    sb.append(" ");
                    sb.append(Type.string(i));
                }
                i = (short)(i + 1);
            }
        }
        return sb.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.next == null) {
            return;
        }
        this.next.toWire(out, null, canonical);
        int length = this.BitSetLength(this.bitmap);
        int i = 0;
        int t = 0;
        while (i < length) {
            t |= this.bitmap.get(i) ? 1 << 7 - i % 8 : 0;
            if (i % 8 == 7 || i == length - 1) {
                out.writeByte(t);
                t = 0;
            }
            ++i;
        }
    }

    private int BitSetLength(BitSet b) {
        int i = b.size() - 1;
        while (i >= 0) {
            if (b.get(i)) {
                return i + 1;
            }
            --i;
        }
        return -1;
    }
}

