/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;

public class RDFOutput {
    private boolean reportAllVars = false;
    private boolean includeTypeProperties = false;

    public boolean getAllVars() {
        return this.reportAllVars;
    }

    public void setAllVars(boolean all) {
        this.reportAllVars = all;
    }

    public Model toModel(ResultSet resultSet) {
        Model m = GraphFactory.makeJenaDefaultModel();
        this.asRDF(m, resultSet);
        if (m.getNsPrefixURI("rs") == null) {
            m.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (m.getNsPrefixURI("rdf") == null) {
            m.setNsPrefix("rdf", RDF.getURI());
        }
        return m;
    }

    public Resource asRDF(Model model, ResultSet resultSet) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        for (String vName : resultSet.getResultVars()) {
            results.addProperty(ResultSetGraphVocab.resultVariable, vName);
        }
        int count = 0;
        while (resultSet.hasNext()) {
            Iterator<String> iter;
            ++count;
            QuerySolution rBind = resultSet.nextSolution();
            Resource thisSolution = model.createResource();
            if (this.includeTypeProperties) {
                thisSolution.addProperty(RDF.type, (RDFNode)ResultSetGraphVocab.ResultSolution);
            }
            results.addProperty(ResultSetGraphVocab.solution, (RDFNode)thisSolution);
            Iterator<String> iterator = iter = this.getAllVars() ? rBind.varNames() : resultSet.getResultVars().iterator();
            while (iter.hasNext()) {
                Resource thisBinding = model.createResource();
                String rVar = iter.next();
                RDFNode n = rBind.get(rVar);
                if (n == null) continue;
                if (this.includeTypeProperties) {
                    thisBinding.addProperty(RDF.type, (RDFNode)ResultSetGraphVocab.ResultBinding);
                }
                thisBinding.addProperty(ResultSetGraphVocab.variable, rVar);
                thisBinding.addProperty(ResultSetGraphVocab.value, n);
                thisSolution.addProperty(ResultSetGraphVocab.binding, (RDFNode)thisBinding);
            }
        }
        results.addProperty(ResultSetGraphVocab.size, (RDFNode)model.createTypedLiteral(count));
        this.addPrefixes(model);
        return results;
    }

    public Model toModel(boolean result) {
        Model m = GraphFactory.makeJenaDefaultModel();
        this.asRDF(m, result);
        this.addPrefixes(m);
        return m;
    }

    private void addPrefixes(Model model) {
        if (model.getNsPrefixURI("rs") == null) {
            model.setNsPrefix("rs", ResultSetGraphVocab.getURI());
        }
        if (model.getNsPrefixURI("rdf") == null) {
            model.setNsPrefix("rdf", RDF.getURI());
        }
        if (model.getNsPrefixURI("xsd") == null) {
            model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
    }

    public Resource asRDF(Model model, boolean result) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        Literal lit = model.createTypedLiteral(result);
        results.addProperty(ResultSetGraphVocab.p_boolean, (RDFNode)lit);
        return results;
    }
}

