/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

public class LuceneJUnitDividingSelector
extends BaseExtendSelector {
    private int counter;
    private int divisor;
    private int part;

    public void setParameters(Parameter[] pParameters) {
        super.setParameters(pParameters);
        for (int j = 0; j < pParameters.length; ++j) {
            Parameter p = pParameters[j];
            if ("divisor".equalsIgnoreCase(p.getName())) {
                this.divisor = Integer.parseInt(p.getValue());
                continue;
            }
            if ("part".equalsIgnoreCase(p.getName())) {
                this.part = Integer.parseInt(p.getValue());
                continue;
            }
            throw new BuildException("unknown " + p.getName());
        }
    }

    public void verifySettings() {
        super.verifySettings();
        if (this.divisor <= 0 || this.part <= 0) {
            throw new BuildException("part or divisor not set");
        }
        if (this.part > this.divisor) {
            throw new BuildException("part must be <= divisor");
        }
    }

    public boolean isSelected(File dir, String name, File path) {
        this.counter = this.counter % this.divisor + 1;
        return this.counter == this.part;
    }
}

