/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.prj;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.resources.NIOUtilities;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PrjFileReader
implements FileReader {
    ByteBuffer buffer;
    ReadableByteChannel channel;
    CharBuffer charBuffer;
    CharsetDecoder decoder;
    StreamLogging streamLogger = new StreamLogging("PRJ reader");
    CoordinateReferenceSystem cs;
    private boolean memoryMapped = true;

    public PrjFileReader(ShpFiles shpFiles) throws IOException {
        Charset chars = Charset.forName("ISO-8859-1");
        this.decoder = chars.newDecoder();
        this.channel = shpFiles.getReadChannel(ShpFileType.PRJ, this);
        this.streamLogger.open();
        this.init();
        this.decoder.decode(this.buffer, this.charBuffer, true);
        this.buffer.limit(this.buffer.capacity());
        this.charBuffer.flip();
        String wkt = this.charBuffer.toString();
        try {
            this.cs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(wkt);
        }
        catch (FactoryException e) {
            this.cs = null;
        }
    }

    public CoordinateReferenceSystem getCoodinateSystem() {
        return this.cs;
    }

    private int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private void init() throws IOException {
        if (this.channel instanceof FileChannel) {
            FileChannel fc = (FileChannel)this.channel;
            this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            this.buffer.position((int)fc.position());
            this.memoryMapped = true;
        } else {
            int size = 8192;
            this.buffer = ByteBuffer.allocateDirect(size);
            this.fill(this.buffer, this.channel);
            this.buffer.flip();
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.charBuffer = CharBuffer.allocate(8192);
        Charset chars = Charset.forName("ISO-8859-1");
        this.decoder = chars.newDecoder();
    }

    public void close() throws IOException {
        if (this.buffer != null) {
            if (this.buffer instanceof MappedByteBuffer && !this.memoryMapped) {
                NIOUtilities.clean((ByteBuffer)this.buffer);
            }
            this.buffer = null;
        }
        if (this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
    }

    public String id() {
        return this.getClass().getName();
    }
}

