/*
 * Copyright 2006 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dev.cfg;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;

/**
 * Abstract base class for various kinds of deferred binding conditions.
 */
public abstract class Condition {
  public final boolean isTrue(TreeLogger logger, GeneratorContext context,
      String testType) throws UnableToCompleteException {

    boolean logDebug = logger.isLoggable(TreeLogger.DEBUG);

    if (logDebug) {
      String startMsg = getEvalBeforeMessage(testType);
      logger = logger.branch(TreeLogger.DEBUG, startMsg, null);
    }

    boolean result = doEval(logger, context, testType);

    if (logDebug) {
      String afterMsg = getEvalAfterMessage(testType, result);
      logger.log(TreeLogger.DEBUG, afterMsg, null);
    }

    return result;
  }

  protected abstract boolean doEval(TreeLogger logger,
      GeneratorContext context, String testType)
      throws UnableToCompleteException;

  protected abstract String getEvalAfterMessage(String testType, boolean result);

  protected abstract String getEvalBeforeMessage(String testType);
}
