/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

public final class dns {
    private static Resolver res;
    private static Map caches;
    private static Name[] searchPath;
    private static boolean searchPathSet;
    private static boolean initialized;

    private dns() {
    }

    public static String inaddrString(InetAddress addr) {
        byte[] address = addr.getAddress();
        StringBuffer sb = new StringBuffer();
        int i = 3;
        while (i >= 0) {
            sb.append(address[i] & 0xFF);
            sb.append(".");
            --i;
        }
        sb.append("IN-ADDR.ARPA.");
        return sb.toString();
    }

    public static String inaddrString(String s) {
        InetAddress address;
        try {
            address = InetAddress.getByName(s);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return dns.inaddrString(address);
    }

    public static synchronized void setResolver(Resolver res) {
        Lookup.setDefaultResolver(res);
    }

    public static synchronized Resolver getResolver() {
        return Lookup.getDefaultResolver();
    }

    public static synchronized void setSearchPath(String[] domains) {
        if (domains == null || domains.length == 0) {
            Lookup.setDefaultSearchPath((Name[])null);
            return;
        }
        ArrayList<Name> l = new ArrayList<Name>();
        int i = 0;
        while (i < domains.length) {
            try {
                l.add(Name.fromString(domains[i], Name.root));
            }
            catch (TextParseException e) {
                // empty catch block
            }
            ++i;
        }
        searchPath = l.toArray(new Name[l.size()]);
        Lookup.setDefaultSearchPath(searchPath);
    }

    public static synchronized Cache getCache(short dclass) {
        return Lookup.getDefaultCache(dclass);
    }

    public static synchronized Cache getCache() {
        return Lookup.getDefaultCache((short)1);
    }

    public static Record[] getRecords(String namestr, short type, short dclass, byte cred) {
        try {
            Lookup lookup2 = new Lookup(namestr, type, dclass);
            lookup2.setCredibility(cred);
            return lookup2.run();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Record[] getRecords(String namestr, short type, short dclass) {
        return dns.getRecords(namestr, type, dclass, (byte)3);
    }

    public static Record[] getAnyRecords(String namestr, short type, short dclass) {
        return dns.getRecords(namestr, type, dclass, (byte)1);
    }

    public static Record[] getRecords(String name, short type) {
        return dns.getRecords(name, type, (short)1, (byte)3);
    }

    public static Record[] getAnyRecords(String name, short type) {
        return dns.getRecords(name, type, (short)1, (byte)1);
    }

    public static Record[] getRecordsByAddress(String addr, short type) {
        String name = dns.inaddrString(addr);
        return dns.getRecords(name, type, (short)1, (byte)3);
    }

    public static Record[] getAnyRecordsByAddress(String addr, short type) {
        String name = dns.inaddrString(addr);
        return dns.getRecords(name, type, (short)1, (byte)1);
    }
}

