/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.verb.extension;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.crosswalk.Crosswalks;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadVerb;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class Redirect
extends ServerVerb {
    private static final boolean debug = true;
    private static Transformer transformer;
    private static ArrayList validParamNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String construct(HashMap context, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer) throws FileNotFoundException, TransformerException {
        Properties properties = (Properties)context.get("OAIHandler.properties");
        AbstractCatalog abstractCatalog = (AbstractCatalog)context.get("OAIHandler.catalog");
        String baseURL = properties.getProperty("OAIHandler.baseURL");
        if (baseURL == null) {
            try {
                baseURL = request.getRequestURL().toString();
            }
            catch (NoSuchMethodError f) {
                baseURL = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
            }
        }
        StringBuffer sb = new StringBuffer();
        String identifier = request.getParameter("identifier");
        System.out.println("Redirect.construct: identifier=" + identifier);
        Crosswalks crosswalks = abstractCatalog.getCrosswalks();
        try {
            if (identifier == null || identifier.length() == 0) {
                System.out.println("Bad argument");
                throw new BadArgumentException();
            }
            if (!crosswalks.containsValue("oai_dc")) {
                System.out.println("crosswalk not present: oai_dc");
                throw new CannotDisseminateFormatException("oai_dc");
            }
            String metadata = abstractCatalog.getRecord(identifier, "oai_dc");
            if (metadata == null) {
                System.out.println("ID does not exist");
                throw new IdDoesNotExistException(identifier);
            }
            sb.append(metadata);
        }
        catch (BadArgumentException e) {
            e.printStackTrace();
            throw new FileNotFoundException(e.getMessage());
        }
        catch (CannotDisseminateFormatException e) {
            e.printStackTrace();
            throw new FileNotFoundException(e.getMessage());
        }
        catch (IdDoesNotExistException e) {
            e.printStackTrace();
            throw new FileNotFoundException(e.getMessage());
        }
        catch (OAIInternalServerError e) {
            e.printStackTrace();
            return BadVerb.construct(context, request, response, serverTransformer);
        }
        System.out.println("Redirect.construct: prerendered sb=" + sb.toString());
        System.out.println("Redirect.construct: transformer=" + transformer);
        Transformer transformer = Redirect.transformer;
        synchronized (transformer) {
            Redirect.transformer.setParameter("base.url", baseURL);
            String out = ServerVerb.render(response, null, sb.toString(), Redirect.transformer);
            Redirect.transformer.clearParameters();
            System.out.println("Redirect.construct: out=" + out);
            return out;
        }
    }

    static {
        String xsltString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n                              xmlns:oai=\"http://www.openarchives.org/OAI/2.0/\"\n                              xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"\n                              xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n  <xsl:output method=\"html\" version=\"4.0\"/>\n  <xsl:param name=\"base.url\"/>\n\n  <xsl:template match=\"/\">\n    <html xmlns=\"http://www.w3.org/1999/xhtml\">\n      <xsl:choose>\n        <xsl:when test=\"record/metadata/oai_dc:dc/dc:identifier[1]\">\n          <head>\n            <meta http-equiv=\"Refresh\">\n              <xsl:attribute name=\"content\"><xsl:text>0; URL=</xsl:text><xsl:value-of select=\"record/metadata/oai_dc:dc/dc:identifier[1]\" /></xsl:attribute>\n            </meta>\n          </head>\n          <body/>\n       </xsl:when>\n       <xsl:when test=\"$base.url\">\n          <head>\n            <meta http-equiv=\"Refresh\">\n              <xsl:attribute name=\"content\"><xsl:text>0; URL=</xsl:text><xsl:value-of select=\"$base.url\" /><xsl:text>/extension?verb=GetMetadata&amp;metadataPrefix=oai_dc&amp;identifier=</xsl:text><xsl:value-of select=\"record/header/identifier\" /></xsl:attribute>\n            </meta>\n          </head>\n          <body/>\n       </xsl:when>\n       <xsl:otherwise>\n          <head>\n            <title><xsl:text>No dc:identifier field found for &apos;</xsl:text><xsl:value-of select=\"record/header/identifier\"/><xsl:text>&apos;</xsl:text></title>\n          </head>\n          <body>\n            <h1><xsl:text>No dc:identifier field found for &apos;</xsl:text><xsl:value-of select=\"record/header/identifier\"/><xsl:text>&apos;</xsl:text></h1>\n          </body>\n       </xsl:otherwise>\n      </xsl:choose>\n    </html>\n  </xsl:template>\n</xsl:stylesheet>\n";
        try {
            System.out.println("Redirect.<init>: xsltString=" + xsltString);
            StreamSource xslSource = new StreamSource(new StringReader(xsltString));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            transformer = tFactory.newTransformer(xslSource);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        validParamNames = new ArrayList();
        validParamNames.add("verb");
        validParamNames.add("identifier");
    }
}

