/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Switch
extends SvnCommand {
    private File path = null;
    private SVNUrl url;
    private ISVNClientAdapter svnClient;
    private SVNRevision revision = SVNRevision.HEAD;
    private boolean recurse = true;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Switching");
        try {
            iSVNClientAdapter.switchToUrl(this.path, this.url, this.revision, this.recurse);
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Cannot switch to url : " + this.url.toString(), (Throwable)sVNClientException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.path == null || this.url == null) {
            throw new BuildException("path and url must be set");
        }
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setRevision(String string) {
        try {
            this.revision = SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            throw new BuildException("Cannot parse revision : " + string, (Throwable)parseException);
        }
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }
}

