/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class StringDistanceFunction
extends ValueSource {
    protected ValueSource str1;
    protected ValueSource str2;
    protected StringDistance dist;

    public StringDistanceFunction(ValueSource str1, ValueSource str2, StringDistance measure) {
        this.str1 = str1;
        this.str2 = str2;
        this.dist = measure;
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues str1DV = this.str1.getValues(context, reader);
        final DocValues str2DV = this.str2.getValues(context, reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return StringDistanceFunction.this.dist.getDistance(str1DV.strVal(doc), str2DV.strVal(doc));
            }

            public int intVal(int doc) {
                return (int)this.doubleVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append("strdist").append('(');
                sb.append(str1DV.toString(doc)).append(',').append(str2DV.toString(doc)).append(", dist=").append(StringDistanceFunction.this.dist.getClass().getName());
                sb.append(')');
                return sb.toString();
            }
        };
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("strdist").append('(');
        sb.append(this.str1).append(',').append(this.str2).append(", dist=").append(this.dist.getClass().getName());
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringDistanceFunction)) {
            return false;
        }
        StringDistanceFunction that = (StringDistanceFunction)o;
        if (!this.dist.equals(that.dist)) {
            return false;
        }
        if (!this.str1.equals(that.str1)) {
            return false;
        }
        return this.str2.equals(that.str2);
    }

    public int hashCode() {
        int result = this.str1.hashCode();
        result = 31 * result + this.str2.hashCode();
        result = 31 * result + this.dist.hashCode();
        return result;
    }
}

