/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.wicket.Component;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.IPageRendererProvider;
import org.apache.wicket.IRequestCycleProvider;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.core.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.ListenerInterfaceRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.feedback.FeedbackCollector;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupParser;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmitListener;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ILinkListener;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.mock.MockApplication;
import org.apache.wicket.mock.MockPageManager;
import org.apache.wicket.mock.MockRequestParameters;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.mock.Cookies;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.protocol.http.mock.MockHttpServletResponse;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.protocol.http.mock.MockServletContext;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebResponse;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.tester.ComponentInPage;
import org.apache.wicket.util.tester.DiffUtil;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.Result;
import org.apache.wicket.util.tester.TagTester;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseWicketTester {
    private static final Logger log = LoggerFactory.getLogger(BaseWicketTester.class);
    private final ServletContext servletContext;
    private MockHttpSession httpSession;
    private final WebApplication application;
    private boolean followRedirects = true;
    private int redirectCount;
    private MockHttpServletRequest lastRequest;
    private MockHttpServletResponse lastResponse;
    private final List<MockHttpServletRequest> previousRequests = Generics.newArrayList();
    private final List<MockHttpServletResponse> previousResponses = Generics.newArrayList();
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private Session session;
    private RequestCycle requestCycle;
    private Page lastRenderedPage;
    private boolean exposeExceptions = true;
    private boolean useRequestUrlAsBase = true;
    private IRequestHandler forcedHandler;
    private IFeedbackMessageFilter originalFeedbackMessageCleanupFilter;
    private ComponentInPage componentInPage;
    private Map<String, String> preHeader;

    public BaseWicketTester() {
        this(new MockApplication());
    }

    public <C extends Page> BaseWicketTester(final Class<C> homePage) {
        this(new MockApplication(){

            @Override
            public Class<? extends Page> getHomePage() {
                return homePage;
            }
        });
    }

    public BaseWicketTester(WebApplication application) {
        this(application, (ServletContext)null);
    }

    public BaseWicketTester(WebApplication application, String servletContextBasePath) {
        this(application, new MockServletContext(application, servletContextBasePath));
    }

    public BaseWicketTester(WebApplication application, ServletContext servletCtx) {
        this.servletContext = servletCtx != null ? servletCtx : new MockServletContext(application, null);
        final TestFilterConfig filterConfig = new TestFilterConfig();
        WicketFilter filter = new WicketFilter(){

            @Override
            public FilterConfig getFilterConfig() {
                return filterConfig;
            }
        };
        application.setWicketFilter(filter);
        this.httpSession = new MockHttpSession(this.servletContext);
        ThreadContext.detach();
        this.application = application;
        application.setName("WicketTesterApplication-" + UUID.randomUUID());
        ThreadContext.setApplication(application);
        application.setServletContext(this.servletContext);
        application.initApplication();
        application.getResourceSettings().setResourcePollFrequency(this.getResourcePollFrequency());
        application.setPageRendererProvider(new LastPageRecordingPageRendererProvider(application.getPageRendererProvider()));
        application.setRequestCycleProvider(new TestRequestCycleProvider(application.getRequestCycleProvider()));
        this.originalFeedbackMessageCleanupFilter = application.getApplicationSettings().getFeedbackMessageCleanupFilter();
        application.getApplicationSettings().setFeedbackMessageCleanupFilter(IFeedbackMessageFilter.NONE);
        IPageManagerProvider pageManagerProvider = this.newTestPageManagerProvider();
        if (pageManagerProvider != null) {
            application.setPageManagerProvider(pageManagerProvider);
        }
        application.getSessionStore().registerUnboundListener(new ISessionStore.UnboundListener(){

            @Override
            public void sessionUnbound(String sessionId) {
                BaseWicketTester.this.newSession();
            }
        });
        this.setupNextRequestCycle();
    }

    protected Duration getResourcePollFrequency() {
        return null;
    }

    protected IPageManagerProvider newTestPageManagerProvider() {
        return new TestPageManagerProvider();
    }

    public Page getLastRenderedPage() {
        return this.lastRenderedPage;
    }

    private void setupNextRequestCycle() {
        boolean assignBaseLocation;
        this.request = new MockHttpServletRequest(this.application, this.httpSession, this.servletContext);
        this.request.setURL(this.request.getContextPath() + this.request.getServletPath() + "/");
        boolean bl = assignBaseLocation = this.lastRequest != null && this.lastRequest.getHeader("Wicket-Ajax") == null;
        if (assignBaseLocation) {
            this.request.setScheme(this.lastRequest.getScheme());
            this.request.setSecure(this.lastRequest.isSecure());
            this.request.setServerName(this.lastRequest.getServerName());
            this.request.setServerPort(this.lastRequest.getServerPort());
        }
        this.transferRequestCookies();
        this.response = new MockHttpServletResponse(this.request);
        if (this.lastResponse != null && this.lastResponse.isRedirect()) {
            List<Cookie> lastResponseCookies = this.lastResponse.getCookies();
            for (Cookie cookie : lastResponseCookies) {
                if (cookie.getMaxAge() == 0) continue;
                this.response.addCookie(cookie);
            }
        }
        ServletWebRequest servletWebRequest = this.newServletWebRequest();
        this.requestCycle = this.application.createRequestCycle((Request)servletWebRequest, this.newServletWebResponse(servletWebRequest));
        ThreadContext.setRequestCycle(this.requestCycle);
        if (this.session == null) {
            this.newSession();
        }
    }

    public void cleanupFeedbackMessages() {
        this.cleanupFeedbackMessages(this.originalFeedbackMessageCleanupFilter);
    }

    public void clearFeedbackMessages() {
        this.cleanupFeedbackMessages(IFeedbackMessageFilter.ALL);
    }

    private void cleanupFeedbackMessages(IFeedbackMessageFilter filter) {
        this.application.getApplicationSettings().setFeedbackMessageCleanupFilter(filter);
        this.getLastRenderedPage().detach();
        this.getSession().detach();
        this.application.getApplicationSettings().setFeedbackMessageCleanupFilter(IFeedbackMessageFilter.NONE);
    }

    private void transferRequestCookies() {
        List<Cookie> cookies;
        ArrayList<Cookie> lastRequestCookies = new ArrayList<Cookie>();
        if (this.lastRequest != null && this.lastRequest.getCookies() != null) {
            for (Cookie lastRequestCookie : this.lastRequest.getCookies()) {
                lastRequestCookies.add(lastRequestCookie);
            }
        }
        if (this.lastResponse != null && (cookies = this.lastResponse.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getMaxAge() == 0) {
                    Iterator cookieIterator = lastRequestCookies.iterator();
                    while (cookieIterator.hasNext()) {
                        Cookie lastRequestCookie = (Cookie)cookieIterator.next();
                        if (!Cookies.isEqual(lastRequestCookie, cookie)) continue;
                        cookieIterator.remove();
                    }
                    continue;
                }
                boolean newlyCreated = true;
                for (Cookie oldCookie : lastRequestCookies) {
                    if (!Cookies.isEqual(cookie, oldCookie)) continue;
                    newlyCreated = false;
                    break;
                }
                if (!newlyCreated) continue;
                lastRequestCookies.add(cookie);
            }
        }
        this.request.addCookies(lastRequestCookies);
    }

    protected Response newServletWebResponse(ServletWebRequest servletWebRequest) {
        return new WicketTesterServletWebResponse(servletWebRequest, this.response);
    }

    private ServletWebRequest newServletWebRequest() {
        return (ServletWebRequest)this.application.newWebRequest(this.request, this.request.getFilterPrefix());
    }

    private void newSession() {
        ThreadContext.setSession(null);
        this.session = Session.get();
    }

    public MockHttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(MockHttpServletRequest request) {
        this.request = request;
        this.applyRequest();
    }

    public Session getSession() {
        return this.session;
    }

    public MockHttpSession getHttpSession() {
        return this.httpSession;
    }

    public WebApplication getApplication() {
        return this.application;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void destroy() {
        this.application.internalDestroy();
        ThreadContext.detach();
    }

    public boolean processRequest() {
        return this.processRequest(null, null);
    }

    public boolean processRequest(MockHttpServletRequest request) {
        return this.processRequest(request, null);
    }

    public boolean processRequest(MockHttpServletRequest request, IRequestHandler forcedRequestHandler) {
        return this.processRequest(request, forcedRequestHandler, false);
    }

    public boolean processRequest(IRequestHandler forcedRequestHandler) {
        return this.processRequest(null, forcedRequestHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequest(MockHttpServletRequest forcedRequest, IRequestHandler forcedRequestHandler, boolean redirect) {
        if (forcedRequest != null) {
            this.request = forcedRequest;
        }
        this.forcedHandler = forcedRequestHandler;
        if (!redirect && this.getRequest().getHeader("Wicket-Ajax") == null) {
            this.lastRenderedPage = null;
        }
        if (this.request != null && this.preHeader != null) {
            for (Map.Entry<String, String> entry : this.preHeader.entrySet()) {
                if (Strings.isEmpty((CharSequence)entry.getKey())) continue;
                this.request.setHeader(entry.getKey(), entry.getValue());
            }
            this.preHeader = null;
        }
        try {
            this.transferRequestCookies();
            this.applyRequest();
            this.requestCycle.scheduleRequestHandlerAfterCurrent(null);
            if (!this.requestCycle.processRequestAndDetach()) {
                boolean i$ = false;
                return i$;
            }
            this.recordRequestResponse();
            this.setupNextRequestCycle();
            if (this.followRedirects && this.lastResponse.isRedirect()) {
                if (this.redirectCount++ >= 100) {
                    Assert.fail((String)"Possible infinite redirect detected. Bailing out.");
                }
                Url newUrl = Url.parse((CharSequence)this.lastResponse.getRedirectLocation(), (Charset)Charset.forName(this.request.getCharacterEncoding()));
                if (this.isExternalRedirect(this.lastRequest.getUrl(), newUrl)) {
                    boolean entry = true;
                    return entry;
                }
                if (newUrl.isAbsolute()) {
                    this.request.setUrl(newUrl);
                    String protocol = newUrl.getProtocol();
                    if (protocol != null) {
                        this.request.setScheme(protocol);
                    }
                    this.request.setSecure("https".equals(protocol));
                    if (newUrl.getHost() != null) {
                        this.request.setServerName(newUrl.getHost());
                    }
                    if (newUrl.getPort() != null) {
                        this.request.setServerPort(newUrl.getPort());
                    }
                } else {
                    Url mergedURL = new Url(this.lastRequest.getUrl().getSegments(), newUrl.getQueryParameters());
                    mergedURL.concatSegments(newUrl.getSegments());
                    this.request.setUrl(mergedURL);
                }
                this.processRequest(null, null, true);
                --this.redirectCount;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.redirectCount = 0;
        }
    }

    private boolean isExternalRedirect(Url requestUrl, Url newUrl) {
        String originalHost = requestUrl.getHost();
        String redirectHost = newUrl.getHost();
        Integer originalPort = requestUrl.getPort();
        Integer newPort = newUrl.getPort();
        if (originalHost.equals(redirectHost)) {
            return false;
        }
        if (redirectHost == null) {
            return false;
        }
        if (!originalPort.equals(newPort)) {
            return true;
        }
        return !redirectHost.equals(originalHost);
    }

    public final void addRequestHeader(String key, String value) {
        Args.notEmpty((CharSequence)key, (String)"key");
        if (this.preHeader == null) {
            this.preHeader = Generics.newHashMap();
        }
        this.preHeader.put(key, value);
    }

    private void recordRequestResponse() {
        this.lastRequest = this.request;
        this.lastResponse = this.response;
        this.previousRequests.add(this.request);
        this.previousResponses.add(this.response);
    }

    public Page startPage(IPageProvider pageProvider) {
        this.componentInPage = null;
        this.request.setURL(this.request.getContextPath() + this.request.getServletPath() + "/");
        RenderPageRequestHandler handler = new RenderPageRequestHandler(pageProvider);
        this.processRequest(this.request, handler);
        return this.getLastRenderedPage();
    }

    public <T extends Page> T startPage(T page) {
        return (T)this.startPage(new PageProvider(page));
    }

    public ResourceReference startResource(final IResource resource) {
        return this.startResourceReference(new ResourceReference("testResourceReference"){
            private static final long serialVersionUID = 1L;

            @Override
            public IResource getResource() {
                return resource;
            }
        });
    }

    public ResourceReference startResourceReference(ResourceReference reference) {
        return this.startResourceReference(reference, null);
    }

    public ResourceReference startResourceReference(ResourceReference reference, PageParameters pageParameters) {
        this.request.setURL(this.request.getContextPath() + this.request.getServletPath() + "/");
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(reference, pageParameters);
        this.processRequest(this.request, handler);
        return reference;
    }

    public MockHttpServletResponse getLastResponse() {
        return this.lastResponse;
    }

    public String getLastResponseAsString() {
        String response = this.lastResponse.getDocument();
        if (this.componentInPage == null) {
            return response;
        }
        int end = response.lastIndexOf("</body>");
        if (end > -1) {
            int start = response.indexOf("<body>") + "<body>".length();
            response = response.substring(start, end);
        }
        return response;
    }

    public String getWicketAjaxBaseUrlEncodedInLastResponse() throws IOException, ResourceStreamNotFoundException, ParseException {
        XmlTag tag;
        XmlPullParser parser = new XmlPullParser();
        parser.parse(this.getLastResponseAsString());
        while ((tag = parser.nextTag()) != null) {
            if (!tag.isOpen() || !tag.getName().equals("script") || !"wicket-ajax-base-url".equals(tag.getAttribute("id"))) continue;
            parser.next();
            return ((Object)parser.getString()).toString().split("\\\"")[1];
        }
        Assert.fail((String)"Last response has no AJAX base URL set by AbstractDefaultAjaxBehavior.");
        return null;
    }

    public List<MockHttpServletRequest> getPreviousRequests() {
        return Collections.unmodifiableList(this.previousRequests);
    }

    public List<MockHttpServletResponse> getPreviousResponses() {
        return Collections.unmodifiableList(this.previousResponses);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public Url urlFor(IRequestHandler handler) {
        Url url = this.application.getRootRequestMapper().mapHandler(handler);
        return this.transform(url);
    }

    public String urlFor(Link<?> link) {
        Args.notNull(link, (String)"link");
        Url url = Url.parse((CharSequence)((Object)link.urlFor(ILinkListener.INTERFACE, new PageParameters())).toString());
        return this.transform(url).toString();
    }

    public void executeListener(Component component, RequestListenerInterface listener) {
        Args.notNull((Object)component, (String)"component");
        ListenerInterfaceRequestHandler handler = new ListenerInterfaceRequestHandler(new PageAndComponentProvider((IRequestablePage)component.getPage(), component), listener);
        Url url = this.urlFor(handler);
        MockHttpServletRequest request = new MockHttpServletRequest(this.application, this.httpSession, this.servletContext);
        request.setUrl(url);
        this.processRequest(request, null);
    }

    public void invokeListener(Component component, RequestListenerInterface listener) {
        Args.notNull((Object)component, (String)"component");
        ListenerInterfaceRequestHandler handler = new ListenerInterfaceRequestHandler(new PageAndComponentProvider((IRequestablePage)component.getPage(), component), listener);
        this.processRequest(handler);
    }

    public void executeListener(Component component) {
        Args.notNull((Object)component, (String)"component");
        for (RequestListenerInterface iface : RequestListenerInterface.getRegisteredInterfaces()) {
            if (!iface.getListenerInterfaceClass().isAssignableFrom(component.getClass())) continue;
            this.executeListener(component, iface);
        }
    }

    public void executeBehavior(AbstractAjaxBehavior behavior) {
        Args.notNull((Object)behavior, (String)"behavior");
        Url url = Url.parse((CharSequence)((Object)behavior.getCallbackUrl()).toString(), (Charset)Charset.forName(this.request.getCharacterEncoding()));
        this.transform(url);
        this.request.setUrl(url);
        this.request.addHeader("Wicket-Ajax-BaseURL", url.toString());
        this.request.addHeader("Wicket-Ajax", "true");
        if (behavior instanceof AjaxFormSubmitBehavior) {
            AjaxFormSubmitBehavior formSubmitBehavior = (AjaxFormSubmitBehavior)behavior;
            Form<?> form = formSubmitBehavior.getForm();
            this.getRequest().setUseMultiPartContentType(form.isMultiPart());
            this.serializeFormToRequest(form);
        }
        this.processRequest();
    }

    public Url urlFor(AjaxLink<?> link) {
        AjaxEventBehavior behavior = WicketTesterHelper.findAjaxEventBehavior(link, "onclick");
        Url url = Url.parse((CharSequence)((Object)behavior.getCallbackUrl()).toString(), (Charset)Charset.forName(this.request.getCharacterEncoding()));
        return this.transform(url);
    }

    public void executeAjaxUrl(Url url) {
        Args.notNull((Object)url, (String)"url");
        this.transform(url);
        this.request.setUrl(url);
        this.request.addHeader("Wicket-Ajax-BaseURL", url.toString());
        this.request.addHeader("Wicket-Ajax", "true");
        this.processRequest();
    }

    public final <C extends Page> C startPage(Class<C> pageClass) {
        return this.startPage(pageClass, null);
    }

    public final <C extends Page> C startPage(Class<C> pageClass, PageParameters parameters) {
        Args.notNull(pageClass, (String)"pageClass");
        this.componentInPage = null;
        this.request.setUrl(this.application.getRootRequestMapper().mapHandler((IRequestHandler)new BookmarkablePageRequestHandler(new PageProvider(pageClass, parameters))));
        this.processRequest();
        return (C)this.getLastRenderedPage();
    }

    public FormTester newFormTester(String path) {
        return this.newFormTester(path, true);
    }

    public FormTester newFormTester(String path, boolean fillBlankString) {
        return new FormTester(path, (Form)this.getComponentFromLastRenderedPage(path), this, fillBlankString);
    }

    public final <C extends Component> C startComponentInPage(Class<C> componentClass) {
        return (C)this.startComponentInPage((C)((Object)componentClass), null);
    }

    public final <C extends Component> C startComponentInPage(Class<C> componentClass, IMarkupFragment pageMarkup) {
        Args.notNull(componentClass, (String)"componentClass");
        Component comp = null;
        try {
            Constructor<C> c = componentClass.getConstructor(String.class);
            comp = (Component)c.newInstance("testObject");
            this.componentInPage = new ComponentInPage();
            this.componentInPage.component = comp;
            this.componentInPage.isInstantiated = true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)String.format("Cannot instantiate component with type '%s' because of '%s'", componentClass.getName(), e.getMessage()));
        }
        return (C)this.startComponentInPage(comp, pageMarkup);
    }

    public final <C extends Component> C startComponentInPage(C component) {
        return this.startComponentInPage(component, null);
    }

    public final <C extends Component> C startComponentInPage(C component, IMarkupFragment pageMarkup) {
        Args.notNull(component, (String)"component");
        Page page = this.createPage();
        if (page == null) {
            Assert.fail((String)"The automatically created page should not be null.");
        }
        if (pageMarkup == null) {
            String markup = this.createPageMarkup(component.getId());
            if (markup == null) {
                Assert.fail((String)"The markup for the automatically created page should not be null.");
            }
            try {
                ContainerInfo containerInfo = new ContainerInfo(page);
                MarkupResourceStream markupResourceStream = new MarkupResourceStream((IResourceStream)new StringResourceStream((CharSequence)markup), containerInfo, page.getClass());
                MarkupParser markupParser = this.getApplication().getMarkupSettings().getMarkupFactory().newMarkupParser(markupResourceStream);
                pageMarkup = markupParser.parse();
            }
            catch (Exception e) {
                Assert.fail((String)("Error while parsing the markup for the autogenerated page: " + e.getMessage()));
            }
        }
        page.setMarkup(pageMarkup);
        page.add(component);
        ComponentInPage oldComponentInPage = this.componentInPage;
        this.startPage(page);
        if (oldComponentInPage != null) {
            this.componentInPage = oldComponentInPage;
        } else {
            this.componentInPage = new ComponentInPage();
            this.componentInPage.component = component;
        }
        return component;
    }

    protected String createPageMarkup(String componentId) {
        return "<html><head></head><body><span wicket:id='" + componentId + "'></span></body></html>";
    }

    protected Page createPage() {
        return new StartComponentInPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Component startComponent(Component component) {
        try {
            component.internalInitialize();
            if (component instanceof FormComponent) {
                ((FormComponent)component).processInput();
            }
            component.beforeRender();
        }
        finally {
            this.getRequestCycle().detach();
            component.detach();
        }
        return component;
    }

    public Component getComponentFromLastRenderedPage(String path, boolean wantVisibleInHierarchy) {
        Component component;
        String componentIdPageId;
        if (this.componentInPage != null && this.componentInPage.isInstantiated && !path.startsWith(componentIdPageId = this.componentInPage.component.getId() + ':')) {
            path = componentIdPageId + path;
        }
        if ((component = this.getLastRenderedPage().get(path)) == null) {
            Assert.fail((String)("path: '" + path + "' does not exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())));
            return null;
        }
        if (!wantVisibleInHierarchy || component.isVisibleInHierarchy()) {
            return component;
        }
        return null;
    }

    public Component getComponentFromLastRenderedPage(String path) {
        return this.getComponentFromLastRenderedPage(path, true);
    }

    public Result hasLabel(String path, String expectedLabelText) {
        Label label = (Label)this.getComponentFromLastRenderedPage(path);
        return this.isEqual(expectedLabelText, label.getDefaultModelObjectAsString());
    }

    public <C extends Component> Result isComponent(String path, Class<C> expectedComponentClass) {
        Component component = this.getComponentFromLastRenderedPage(path);
        if (component == null) {
            return Result.fail("Component not found: " + path);
        }
        return this.isTrue("component '" + Classes.simpleName(component.getClass()) + "' is not type:" + Classes.simpleName(expectedComponentClass), expectedComponentClass.isAssignableFrom(component.getClass()));
    }

    public Result isVisible(String path) {
        Component component = this.getComponentFromLastRenderedPage(path, false);
        Result result = component == null ? Result.fail("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())) : this.isTrue("component '" + path + "' is not visible", component.isVisibleInHierarchy());
        return result;
    }

    public Result isInvisible(String path) {
        Component component = this.getComponentFromLastRenderedPage(path, false);
        Result result = component == null ? Result.fail("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())) : this.isFalse("component '" + path + "' is visible", component.isVisibleInHierarchy());
        return result;
    }

    public Result isEnabled(String path) {
        Component component = this.getComponentFromLastRenderedPage(path);
        if (component == null) {
            Assert.fail((String)("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())));
        }
        return this.isTrue("component '" + path + "' is disabled", component.isEnabledInHierarchy());
    }

    public Result isDisabled(String path) {
        Component component = this.getComponentFromLastRenderedPage(path);
        if (component == null) {
            Assert.fail((String)("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())));
        }
        return this.isFalse("component '" + path + "' is enabled", component.isEnabledInHierarchy());
    }

    public Result isRequired(String path) {
        Component component = this.getComponentFromLastRenderedPage(path);
        if (component == null) {
            Assert.fail((String)("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass())));
        } else if (!(component instanceof FormComponent)) {
            Assert.fail((String)("path: '" + path + "' is not a form component"));
        }
        return this.isRequired((FormComponent)component);
    }

    public Result isRequired(FormComponent<?> component) {
        return this.isTrue("component '" + component + "' is not required", component.isRequired());
    }

    public Result ifContains(String pattern) {
        return this.isTrue("pattern '" + pattern + "' not found in:\n" + this.getLastResponseAsString(), this.getLastResponseAsString().matches("(?s).*" + pattern + ".*"));
    }

    public Result ifContainsNot(String pattern) {
        return this.isFalse("pattern '" + pattern + "' found", this.getLastResponseAsString().matches("(?s).*" + pattern + ".*"));
    }

    public void assertListView(String path, List<?> expectedList) {
        ListView listView = (ListView)this.getComponentFromLastRenderedPage(path);
        WicketTesterHelper.assertEquals(expectedList, listView.getList());
    }

    public void clickLink(String path) {
        this.clickLink(path, true);
    }

    public void clickLink(String path, boolean isAjax) {
        Component linkComponent = this.getComponentFromLastRenderedPage(path);
        this.checkUsability(linkComponent, true);
        if (linkComponent instanceof AjaxLink) {
            if (!isAjax) {
                Assert.fail((String)("Link " + path + "is an AjaxLink and will " + "not be invoked when AJAX (javascript) is disabled."));
            }
            List<AjaxEventBehavior> behaviors = WicketTesterHelper.findAjaxEventBehaviors(linkComponent, "onclick");
            for (AjaxEventBehavior behavior : behaviors) {
                this.executeBehavior(behavior);
            }
        } else if (linkComponent instanceof AjaxFallbackLink && isAjax) {
            List<AjaxEventBehavior> behaviors = WicketTesterHelper.findAjaxEventBehaviors(linkComponent, "onclick");
            for (AjaxEventBehavior behavior : behaviors) {
                this.executeBehavior(behavior);
            }
        } else if (linkComponent instanceof AjaxSubmitLink) {
            if (!isAjax) {
                Assert.fail((String)("Link " + path + " is an AjaxSubmitLink and " + "will not be invoked when AJAX (javascript) is disabled."));
            }
            AjaxSubmitLink link = (AjaxSubmitLink)linkComponent;
            String pageRelativePath = link.getInputName();
            this.request.getPostParameters().setParameterValue(pageRelativePath, "x");
            this.submitAjaxFormSubmitBehavior(link, (AjaxFormSubmitBehavior)WicketTesterHelper.findAjaxEventBehavior(link, "onclick"));
        } else if (linkComponent instanceof SubmitLink) {
            SubmitLink submitLink = (SubmitLink)linkComponent;
            String pageRelativePath = submitLink.getInputName();
            this.request.getPostParameters().setParameterValue(pageRelativePath, "x");
            this.serializeFormToRequest(submitLink.getForm());
            this.submitForm(submitLink.getForm().getPageRelativePath());
        } else if (linkComponent instanceof AbstractLink) {
            AbstractLink link = (AbstractLink)linkComponent;
            if (link instanceof BookmarkablePageLink) {
                BookmarkablePageLink bookmarkablePageLink = (BookmarkablePageLink)link;
                try {
                    Method getParametersMethod = BookmarkablePageLink.class.getDeclaredMethod("getPageParameters", null);
                    getParametersMethod.setAccessible(true);
                    PageParameters parameters = (PageParameters)getParametersMethod.invoke((Object)bookmarkablePageLink, (Object[])null);
                    this.startPage(bookmarkablePageLink.getPageClass(), parameters);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Internal error in WicketTester. Please report this in Wicket's Issue Tracker.", e);
                }
            } else if (link instanceof ResourceLink) {
                try {
                    Method getURL = ResourceLink.class.getDeclaredMethod("getURL", new Class[0]);
                    getURL.setAccessible(true);
                    CharSequence url = (CharSequence)getURL.invoke((Object)link, new Object[0]);
                    this.executeUrl(((Object)url).toString());
                }
                catch (Exception x) {
                    throw new RuntimeException("An error occurred while clicking on a ResourceLink", x);
                }
            } else {
                this.executeListener(link, ILinkListener.INTERFACE);
            }
        } else {
            Assert.fail((String)("Link " + path + " is not a Link, AjaxLink, AjaxFallbackLink or AjaxSubmitLink"));
        }
    }

    public void submitForm(Form<?> form) {
        this.submitForm(form.getPageRelativePath());
    }

    public void submitForm(String path) {
        Form form = (Form)this.getComponentFromLastRenderedPage(path);
        Url url = Url.parse((CharSequence)((Object)form.getRootForm().urlFor(IFormSubmitListener.INTERFACE, new PageParameters())).toString(), (Charset)Charset.forName(this.request.getCharacterEncoding()));
        this.transform(url);
        this.request.setUrl(url);
        this.processRequest();
    }

    private Url transform(Url url) {
        while (url.getSegments().size() > 0 && (((String)url.getSegments().get(0)).equals("..") || ((String)url.getSegments().get(0)).equals("."))) {
            url.getSegments().remove(0);
        }
        return url;
    }

    public <C extends Page> Result isRenderedPage(Class<C> expectedRenderedPageClass) {
        Args.notNull(expectedRenderedPageClass, (String)"expectedRenderedPageClass");
        Page page = this.getLastRenderedPage();
        if (page == null) {
            return Result.fail("page was null");
        }
        if (!expectedRenderedPageClass.isAssignableFrom(page.getClass())) {
            return Result.fail(String.format("classes not the same, expected '%s', current '%s'", expectedRenderedPageClass, page.getClass()));
        }
        return Result.pass();
    }

    public void assertResultPage(Class<?> pageClass, String filename) throws Exception {
        String document = this.getLastResponseAsString();
        DiffUtil.validatePage(document, pageClass, filename, true);
    }

    public Result isResultPage(String expectedDocument) throws Exception {
        String document = this.getLastResponseAsString();
        return this.isTrue("expected rendered page equals", document.equals(expectedDocument));
    }

    public Result hasNoErrorMessage() {
        List<Serializable> messages = this.getMessages(400);
        return this.isTrue("expect no error message, but contains\n" + WicketTesterHelper.asLined(messages), messages.isEmpty());
    }

    public Result hasNoInfoMessage() {
        List<Serializable> messages = this.getMessages(200);
        return this.isTrue("expect no info message, but contains\n" + WicketTesterHelper.asLined(messages), messages.isEmpty());
    }

    public List<Serializable> getMessages(final int level) {
        List<FeedbackMessage> allMessages = new FeedbackCollector(this.getLastRenderedPage()).collect(new IFeedbackMessageFilter(){

            @Override
            public boolean accept(FeedbackMessage message) {
                return message.getLevel() == level;
            }
        });
        ArrayList actualMessages = Generics.newArrayList();
        for (FeedbackMessage message : allMessages) {
            actualMessages.add(message.getMessage());
        }
        return actualMessages;
    }

    public void dumpPage() {
        log.info(this.getLastResponseAsString());
    }

    public void debugComponentTrees() {
        this.debugComponentTrees("");
    }

    public void debugComponentTrees(String filter) {
        log.info("debugging ----------------------------------------------");
        for (WicketTesterHelper.ComponentData obj : WicketTesterHelper.getComponentData(this.getLastRenderedPage())) {
            if (!obj.path.matches(".*" + filter + ".*")) continue;
            log.info("path\t" + obj.path + " \t" + obj.type + " \t[" + obj.value + "]");
        }
    }

    public Result isComponentOnAjaxResponse(Component component) {
        Result result;
        String failMessage = "A component which is null could not have been added to the AJAX response";
        this.notNull(failMessage, component);
        if (!component.isVisible() && (result = this.isTrue(failMessage = "A component which is invisible and doesn't render a placeholder tag will not be rendered at all and thus won't be accessible for subsequent AJAX interaction", component.getOutputMarkupPlaceholderTag())).wasFailed()) {
            return result;
        }
        String ajaxResponse = this.getLastResponseAsString();
        failMessage = "The Previous response was not an AJAX response. You need to execute an AJAX event, using clickLink, before using this assert";
        boolean isAjaxResponse = Pattern.compile("^<\\?xml version=\"1.0\" encoding=\".*?\"\\?><ajax-response>").matcher(ajaxResponse).find();
        result = this.isTrue(failMessage, isAjaxResponse);
        if (result.wasFailed()) {
            return result;
        }
        failMessage = "The component doesn't have a markup id, which means that it can't have been added to the AJAX response";
        String markupId = component.getMarkupId();
        result = this.isTrue(failMessage, !Strings.isEmpty((CharSequence)markupId));
        if (result.wasFailed()) {
            return result;
        }
        boolean isComponentInAjaxResponse = ajaxResponse.matches("(?s).*<component id=\"" + markupId + "\"[^>]*?>.*");
        failMessage = "Component wasn't found in the AJAX response";
        return this.isTrue(failMessage, isComponentInAjaxResponse);
    }

    public void executeAjaxEvent(String componentPath, String event) {
        Component component = this.getComponentFromLastRenderedPage(componentPath);
        this.executeAjaxEvent(component, event);
    }

    public void executeAllTimerBehaviors(MarkupContainer page) {
        this.internalExecuteAllTimerBehaviors(page);
        page.visitChildren(Component.class, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                BaseWicketTester.this.internalExecuteAllTimerBehaviors(component);
            }
        });
    }

    private void internalExecuteAllTimerBehaviors(Component component) {
        List<AbstractAjaxTimerBehavior> behaviors = component.getBehaviors(AbstractAjaxTimerBehavior.class);
        for (AbstractAjaxTimerBehavior timer : behaviors) {
            this.checkUsability(component, true);
            if (timer.isStopped()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Triggering AjaxSelfUpdatingTimerBehavior: {}", (Object)component.getClassRelativePath());
            }
            this.executeBehavior(timer);
        }
    }

    public void executeAjaxEvent(Component component, String event) {
        Args.notNull((Object)component, (String)"component");
        Args.notNull((Object)event, (String)"event");
        this.checkUsability(component, true);
        List<AjaxEventBehavior> ajaxEventBehaviors = WicketTesterHelper.findAjaxEventBehaviors(component, event);
        for (AjaxEventBehavior ajaxEventBehavior : ajaxEventBehaviors) {
            this.executeBehavior(ajaxEventBehavior);
        }
    }

    public TagTester getTagByWicketId(String wicketId) {
        return TagTester.createTagByAttribute(this.getLastResponseAsString(), "wicket:id", wicketId);
    }

    public List<TagTester> getTagsByWicketId(String wicketId) {
        return TagTester.createTagsByAttribute(this.getLastResponseAsString(), "wicket:id", wicketId, false);
    }

    public TagTester getTagById(String id) {
        return TagTester.createTagByAttribute(this.getLastResponseAsString(), "id", id);
    }

    private void submitAjaxFormSubmitBehavior(Component component, AjaxFormSubmitBehavior behavior) {
        Form<?> form = behavior.getForm();
        Assert.assertNotNull((String)"No form attached to the submitlink.", form);
        this.checkUsability(form, true);
        this.serializeFormToRequest(form);
        this.executeBehavior(behavior);
    }

    private void serializeFormToRequest(Form<?> form) {
        final MockRequestParameters postParameters = this.request.getPostParameters();
        final Set<String> currentParameterNamesSet = postParameters.getParameterNames();
        form.visitFormComponents(new IVisitor<FormComponent<?>, Void>(){

            public void component(FormComponent<?> formComponent, IVisit<Void> visit) {
                String inputName = formComponent.getInputName();
                if (!currentParameterNamesSet.contains(inputName)) {
                    String[] values;
                    for (String value : values = FormTester.getInputValue(formComponent)) {
                        postParameters.addParameterValue(inputName, value);
                    }
                }
            }
        });
    }

    public String getContentTypeFromResponseHeader() {
        String contentType = this.getLastResponse().getContentType();
        Assert.assertNotNull((String)"No Content-Type header found", (Object)contentType);
        return contentType;
    }

    public int getContentLengthFromResponseHeader() {
        String contentLength = this.getLastResponse().getHeader("Content-Length");
        Assert.assertNotNull((String)"No Content-Length header found", (Object)contentLength);
        return Integer.parseInt(contentLength);
    }

    public String getLastModifiedFromResponseHeader() {
        return this.getLastResponse().getHeader("Last-Modified");
    }

    public String getContentDispositionFromResponseHeader() {
        return this.getLastResponse().getHeader("Content-Disposition");
    }

    public void applyRequest() {
        ServletWebRequest req = this.newServletWebRequest();
        this.requestCycle.setRequest((Request)req);
        if (this.useRequestUrlAsBase) {
            this.requestCycle.getUrlRenderer().setBaseUrl(req.getUrl());
        }
    }

    private Result isTrue(String message, boolean condition) {
        if (condition) {
            return Result.pass();
        }
        return Result.fail(message);
    }

    private Result isFalse(String message, boolean condition) {
        if (!condition) {
            return Result.pass();
        }
        return Result.fail(message);
    }

    protected final Result isEqual(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return Result.pass();
        }
        if (expected != null && expected.equals(actual)) {
            return Result.pass();
        }
        String message = "expected:<" + expected + "> but was:<" + actual + ">";
        return Result.fail(message);
    }

    private void notNull(String message, Object object) {
        if (object == null) {
            Assert.fail((String)message);
        }
    }

    private Result isNull(String message, Object object) {
        if (object != null) {
            return Result.fail(message);
        }
        return Result.pass();
    }

    protected Result checkUsability(Component component, boolean throwException) {
        Result res = Result.pass();
        if (!component.isVisibleInHierarchy()) {
            res = Result.fail("The component is currently not visible in the hierarchy and thus you can not be used. Component: " + component);
        }
        if (!component.isEnabledInHierarchy()) {
            res = Result.fail("The component is currently not enabled in the hierarchy and thus you can not be used. Component: " + component);
        }
        if (throwException && res.wasFailed()) {
            throw new AssertionFailedError(res.getMessage());
        }
        return res;
    }

    public RequestCycle getRequestCycle() {
        return this.requestCycle;
    }

    public MockHttpServletResponse getResponse() {
        return this.response;
    }

    public MockHttpServletRequest getLastRequest() {
        return this.lastRequest;
    }

    public boolean isExposeExceptions() {
        return this.exposeExceptions;
    }

    public void setExposeExceptions(boolean exposeExceptions) {
        this.exposeExceptions = exposeExceptions;
    }

    public boolean isUseRequestUrlAsBase() {
        return this.useRequestUrlAsBase;
    }

    public void setUseRequestUrlAsBase(boolean setBaseUrl) {
        this.useRequestUrlAsBase = setBaseUrl;
    }

    public void executeUrl(String _url) {
        Url url = Url.parse((CharSequence)_url, (Charset)Charset.forName(this.request.getCharacterEncoding()));
        this.transform(url);
        this.getRequest().setUrl(url);
        this.processRequest();
    }

    private static class WicketTesterServletWebResponse
    extends ServletWebResponse
    implements IMetaDataBufferingWebResponse {
        private List<Cookie> cookies = new ArrayList<Cookie>();

        public WicketTesterServletWebResponse(ServletWebRequest request, MockHttpServletResponse response) {
            super(request, response);
        }

        @Override
        public void addCookie(Cookie cookie) {
            super.addCookie(cookie);
            this.cookies.add(cookie);
        }

        @Override
        public void writeMetaData(WebResponse webResponse) {
            for (Cookie cookie : this.cookies) {
                webResponse.addCookie(cookie);
            }
        }

        @Override
        public void sendRedirect(String url) {
            super.sendRedirect(url);
            try {
                this.getContainerResponse().sendRedirect(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class TestFilterConfig
    implements FilterConfig {
        private final Map<String, String> initParameters = new HashMap<String, String>();

        public TestFilterConfig() {
            this.initParameters.put("filterMappingUrlPattern", "/servlet/*");
        }

        public String getFilterName() {
            return this.getClass().getName();
        }

        public ServletContext getServletContext() {
            return BaseWicketTester.this.servletContext;
        }

        public String getInitParameter(String s) {
            return this.initParameters.get(s);
        }

        public Enumeration<String> getInitParameterNames() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static class TestPageManagerProvider
    implements IPageManagerProvider {
        private TestPageManagerProvider() {
        }

        public IPageManager get(IPageManagerContext pageManagerContext) {
            return new MockPageManager();
        }
    }

    private class TestRequestMapper
    implements IRequestMapper {
        private final IRequestMapper delegate;

        public TestRequestMapper(IRequestMapper delegate) {
            this.delegate = delegate;
        }

        public int getCompatibilityScore(Request request) {
            return this.delegate.getCompatibilityScore(request);
        }

        public Url mapHandler(IRequestHandler requestHandler) {
            return this.delegate.mapHandler(requestHandler);
        }

        public IRequestHandler mapRequest(Request request) {
            if (BaseWicketTester.this.forcedHandler != null) {
                IRequestHandler handler = BaseWicketTester.this.forcedHandler;
                BaseWicketTester.this.forcedHandler = null;
                return handler;
            }
            return this.delegate.mapRequest(request);
        }
    }

    private class TestRequestCycleProvider
    implements IRequestCycleProvider {
        private final IRequestCycleProvider delegate;

        public TestRequestCycleProvider(IRequestCycleProvider delegate) {
            this.delegate = delegate;
        }

        public RequestCycle get(RequestCycleContext context) {
            context.setRequestMapper(new TestRequestMapper(context.getRequestMapper()));
            BaseWicketTester.this.forcedHandler = null;
            context.setExceptionMapper(new TestExceptionMapper(context.getExceptionMapper()));
            return (RequestCycle)this.delegate.get(context);
        }
    }

    private class TestExceptionMapper
    implements IExceptionMapper {
        private final IExceptionMapper delegate;

        public TestExceptionMapper(IExceptionMapper delegate) {
            this.delegate = delegate;
        }

        public IRequestHandler map(Exception e) {
            if (BaseWicketTester.this.exposeExceptions) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new WicketRuntimeException(e);
            }
            return this.delegate.map(e);
        }
    }

    private class LastPageRecordingPageRendererProvider
    implements IPageRendererProvider {
        private final IPageRendererProvider delegate;
        private Page lastPage;

        public LastPageRecordingPageRendererProvider(IPageRendererProvider delegate) {
            this.delegate = delegate;
        }

        public PageRenderer get(RenderPageRequestHandler handler) {
            Page newPage = (Page)handler.getPageProvider().getPageInstance();
            if (BaseWicketTester.this.componentInPage != null && this.lastPage != null && this.lastPage.getPageClass() != newPage.getPageClass()) {
                BaseWicketTester.this.componentInPage = null;
            }
            this.lastPage = newPage;
            BaseWicketTester.this.lastRenderedPage = this.lastPage;
            return (PageRenderer)this.delegate.get(handler);
        }
    }

    public static class StartComponentInPage
    extends WebPage {
        private transient IMarkupFragment pageMarkup = null;

        public StartComponentInPage() {
            this.setStatelessHint(false);
        }

        @Override
        public IMarkupFragment getMarkup() {
            IMarkupFragment calculatedMarkup = null;
            if (this.pageMarkup == null) {
                IMarkupFragment markup = super.getMarkup();
                if (markup != null && markup != Markup.NO_MARKUP) {
                    calculatedMarkup = markup;
                    this.pageMarkup = markup;
                }
            } else {
                calculatedMarkup = this.pageMarkup;
            }
            return calculatedMarkup;
        }
    }
}

