/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.RecordFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileRecordFactory
extends RecordFactory {
    private String repositoryIdentifier = null;

    public FileRecordFactory(Properties properties) throws IllegalArgumentException {
        super(properties);
        this.repositoryIdentifier = properties.getProperty("FileRecordFactory.repositoryIdentifier");
        if (this.repositoryIdentifier == null) {
            throw new IllegalArgumentException("FileRecordFactory.repositoryIdentifier is missing from the properties file");
        }
    }

    public String fromOAIIdentifier(String identifier) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(identifier, ":");
            tokenizer.nextToken();
            tokenizer.nextToken();
            return tokenizer.nextToken();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOAIIdentifier(Object nativeItem) {
        StringBuffer sb = new StringBuffer();
        sb.append("oai:");
        sb.append(this.repositoryIdentifier);
        sb.append(":");
        sb.append(this.getLocalIdentifier(nativeItem));
        return sb.toString();
    }

    public String getLocalIdentifier(Object nativeItem) {
        return (String)((HashMap)nativeItem).get("localIdentifier");
    }

    public String getDatestamp(Object nativeItem) throws IllegalArgumentException {
        return (String)((HashMap)nativeItem).get("lastModified");
    }

    public Iterator getSetSpecs(Object nativeItem) throws IllegalArgumentException {
        return null;
    }

    public Iterator getAbouts(Object nativeItem) throws IllegalArgumentException {
        return null;
    }

    public boolean isDeleted(Object nativeItem) throws IllegalArgumentException {
        return false;
    }

    public String quickCreate(Object nativeItem, String schemaLocation, String metadataPrefix) {
        return null;
    }
}

