/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.solr.analysis.BaseTokenizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockTokenizerFactory
extends BaseTokenizerFactory {
    int pattern;
    boolean enableChecks;

    public void init(Map<String, String> args) {
        super.init(args);
        String patternArg = args.get("pattern");
        if (patternArg == null) {
            patternArg = "whitespace";
        }
        if ("whitespace".equalsIgnoreCase(patternArg)) {
            this.pattern = 0;
        } else if ("keyword".equalsIgnoreCase(patternArg)) {
            this.pattern = 1;
        } else if ("simple".equalsIgnoreCase(patternArg)) {
            this.pattern = 2;
        } else {
            throw new RuntimeException("invalid pattern!");
        }
        this.enableChecks = this.getBoolean("enableChecks", true);
    }

    public Tokenizer create(Reader input) {
        MockTokenizer t = new MockTokenizer(input, this.pattern, false);
        t.setEnableChecks(this.enableChecks);
        return t;
    }
}

