/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.spatial.AbstractPreparedGeometryFilter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Contains;

public class ContainsImpl
extends AbstractPreparedGeometryFilter
implements Contains {
    public ContainsImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)11;
    }

    public boolean evaluate(Object feature) {
        if (feature instanceof SimpleFeature && !this.validate((SimpleFeature)feature)) {
            return false;
        }
        switch (this.literals) {
            case BOTH: {
                return this.cacheValue;
            }
            case RIGHT: {
                Geometry left = this.getLeftGeometry(feature);
                Geometry right = this.rightPreppedGeom.getGeometry();
                return this.basicEvaluate(left, right);
            }
            case LEFT: {
                return this.leftPreppedGeom.contains(this.getRightGeometry(feature));
            }
        }
        Geometry left = this.getLeftGeometry(feature);
        Geometry right = this.getRightGeometry(feature);
        return this.basicEvaluate(left, right);
    }

    protected boolean basicEvaluate(Geometry left, Geometry right) {
        Envelope envRight;
        Envelope envLeft = left.getEnvelopeInternal();
        if (envLeft.contains(envRight = right.getEnvelopeInternal())) {
            return left.contains(right);
        }
        return false;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Contains)this, extraData);
    }
}

