/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.impl.partition.MigrationRequestTask;
import com.hazelcast.impl.partition.MigrationStatus;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MigrationNotification
extends AbstractRemotelyProcessable {
    MigrationRequestTask migrationRequestTask;
    MigrationStatus status;

    public MigrationNotification() {
    }

    public MigrationNotification(MigrationStatus status, MigrationRequestTask migrationRequestTask) {
        this.status = status;
        this.migrationRequestTask = migrationRequestTask;
    }

    public void process() {
        Address from = this.migrationRequestTask.getFromAddress();
        Address to = this.migrationRequestTask.getToAddress();
        int partitionId = this.migrationRequestTask.getPartitionId();
        this.node.concurrentMapManager.getPartitionManager().fireMigrationEvent(this.status, partitionId, from, to);
    }

    public void readData(DataInput in) throws IOException {
        super.readData(in);
        this.migrationRequestTask = new MigrationRequestTask();
        this.migrationRequestTask.readData(in);
        this.status = MigrationStatus.get(in.readByte());
    }

    public void writeData(DataOutput out) throws IOException {
        super.writeData(out);
        this.migrationRequestTask.writeData(out);
        out.writeByte(this.status.getCode());
    }
}

