/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;

public abstract class UIObject {
    private static final String NULL_HANDLE_MSG = "Null widget handle.  If you are creating a composite, ensure that initWidget() has been called.";
    private Element element;

    public static native boolean isVisible(Element var0);

    public static native void setVisible(Element var0, boolean var1);

    protected static void setStyleName(Element elem, String style, boolean add) {
        int lastPos;
        int last;
        int idx;
        if (elem == null) {
            throw new RuntimeException(NULL_HANDLE_MSG);
        }
        if (style.length() == 0) {
            throw new IllegalArgumentException("Cannot pass is an empty string as a style name.");
        }
        String oldStyle = DOM.getAttribute(elem, "className");
        if (oldStyle == null) {
            idx = -1;
            oldStyle = "";
        } else {
            idx = oldStyle.indexOf(style);
        }
        while (idx != -1 && (idx != 0 && oldStyle.charAt(idx - 1) != ' ' || (last = idx + style.length()) != (lastPos = oldStyle.length()) && (last >= lastPos || oldStyle.charAt(last) != ' '))) {
            idx = oldStyle.indexOf(style, idx + 1);
        }
        if (add) {
            if (idx == -1) {
                DOM.setAttribute(elem, "className", oldStyle + " " + style);
            }
        } else if (idx != -1) {
            String begin = oldStyle.substring(0, idx);
            String end = oldStyle.substring(idx + style.length());
            DOM.setAttribute(elem, "className", begin + end);
        }
    }

    public void addStyleName(String style) {
        UIObject.setStyleName(this.element, style, true);
    }

    public int getAbsoluteLeft() {
        return DOM.getAbsoluteLeft(this.getElement());
    }

    public int getAbsoluteTop() {
        return DOM.getAbsoluteTop(this.getElement());
    }

    public Element getElement() {
        return this.element;
    }

    public int getOffsetHeight() {
        return DOM.getIntAttribute(this.element, "offsetHeight");
    }

    public int getOffsetWidth() {
        return DOM.getIntAttribute(this.element, "offsetWidth");
    }

    public String getStyleName() {
        return DOM.getAttribute(this.element, "className");
    }

    public String getTitle() {
        return DOM.getAttribute(this.element, "title");
    }

    public boolean isVisible() {
        return UIObject.isVisible(this.element);
    }

    public void removeStyleName(String style) {
        UIObject.setStyleName(this.element, style, false);
    }

    public void setHeight(String height) {
        DOM.setStyleAttribute(this.element, "height", height);
    }

    public void setPixelSize(int width, int height) {
        if (width >= 0) {
            this.setWidth(width + "px");
        }
        if (height >= 0) {
            this.setHeight(height + "px");
        }
    }

    public void setSize(String width, String height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setStyleName(String style) {
        if (this.element == null) {
            throw new RuntimeException(NULL_HANDLE_MSG);
        }
        DOM.setAttribute(this.element, "className", style);
    }

    public void setTitle(String title) {
        DOM.setAttribute(this.element, "title", title);
    }

    public void setVisible(boolean visible) {
        UIObject.setVisible(this.element, visible);
    }

    public void setWidth(String width) {
        DOM.setStyleAttribute(this.element, "width", width);
    }

    public void sinkEvents(int eventBitsToAdd) {
        DOM.sinkEvents(this.getElement(), eventBitsToAdd | DOM.getEventsSunk(this.getElement()));
    }

    public String toString() {
        if (this.element == null) {
            return "(null handle)";
        }
        return DOM.toString(this.element);
    }

    public void unsinkEvents(int eventBitsToRemove) {
        DOM.sinkEvents(this.getElement(), DOM.getEventsSunk(this.getElement()) & ~eventBitsToRemove);
    }

    protected void setElement(Element elem) {
        this.element = elem;
    }
}

