/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common.query;

import edu.ucsb.nceas.metacat.common.query.EmbeddedSolrQueryService;
import edu.ucsb.nceas.metacat.common.query.SolrQueryService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Subject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HttpSolrQueryService
extends SolrQueryService {
    private static final String SELECTIONPHASE = "/select";
    private static final String SOLR_SYSTEMINFO_URLAPPENDIX = "solr.systeminfo.urlappendix";
    private static final String SOLR_SCHEMA_URLAPPENDIX = "sorl.schema.urlappendix";
    private static final String SOLR_CONFIG_URLAPPENDIX = "solr.config.urlappendix";
    private static final String SPEC_PATH = "//str[@name='solr-spec-version']";
    private static final String FIELDS_PATH = "//fields//field";
    private static final String COPY_FIELDS_PATH = "//copyField";
    private static final String DEST = "dest";
    private static final String TRUE = "true";
    private String solrServerBaseURL = null;
    private CommonsHttpSolrServer httpSolrServer = null;
    private static Log log = LogFactory.getLog(HttpSolrQueryService.class);

    public HttpSolrQueryService(CommonsHttpSolrServer httpSolrServer) {
        if (httpSolrServer == null) {
            throw new NullPointerException("HttpSolrQueryService.constructor - The httpSolrServer parameter can't be null");
        }
        this.httpSolrServer = httpSolrServer;
        this.solrServerBaseURL = httpSolrServer.getBaseURL();
    }

    @Override
    public InputStream query(SolrParams query, Set<Subject> subjects) throws IOException, NotFound {
        boolean xmlFormat = false;
        String queryString = ClientUtils.toQueryString((SolrParams)query, (boolean)xmlFormat);
        log.info((Object)("==========HttpSolrQueryService.query - the query string after transforming from the SolrParams to the string " + queryString));
        StringBuffer accessFilter = this.generateAccessFilterParamsString(subjects);
        if (accessFilter != null && accessFilter.length() != 0) {
            String accessStr = accessFilter.toString();
            log.debug((Object)("==========HttpSolrQueryService.query - the access string is " + accessStr));
            URLCodec urlCodec = new URLCodec();
            accessStr = urlCodec.encode(accessStr, "UTF-8");
            log.debug((Object)("==========HttpSolrQueryService.query - the access string after escape special characters string " + accessStr));
            queryString = queryString + "&" + "fq" + "=" + accessStr;
        }
        queryString = this.solrServerBaseURL + SELECTIONPHASE + queryString;
        log.info((Object)("==========HttpSolrQueryService.query - the final url for querying the solr http server is " + queryString));
        URL url = new URL(queryString);
        return url.openStream();
    }

    @Override
    public Map<String, SchemaField> getIndexSchemaFields() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        if (this.fieldMap == null || this.fieldMap.isEmpty()) {
            this.getIndexSchemaFieldFromServer();
        }
        return this.fieldMap;
    }

    public List<String> getValidSchemaField() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        if (this.fieldMap == null || this.fieldMap.isEmpty()) {
            this.getIndexSchemaFields();
        }
        return super.getValidSchemaFields();
    }

    private void getIndexSchemaFieldFromServer() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        SolrConfig config = new SolrConfig("dataone", new InputSource(this.getSolrConfig()));
        this.schema = new IndexSchema(config, "dataone", new InputSource(this.lookupSchema()));
        this.fieldMap = this.schema.getFields();
    }

    private InputStream getSolrConfig() throws MalformedURLException, IOException {
        String solrConfigAppendix = Settings.getConfiguration().getString(SOLR_CONFIG_URLAPPENDIX);
        String configURL = this.solrServerBaseURL + solrConfigAppendix;
        log.info((Object)("HttpSolrQueryService.getSolrConfig - the url of getting the solr configure file is " + configURL));
        return new URL(configURL).openStream();
    }

    private InputStream lookupSchema() throws MalformedURLException, IOException {
        String schemaURLAppendix = Settings.getConfiguration().getString(SOLR_SCHEMA_URLAPPENDIX);
        String schemaURL = this.solrServerBaseURL + schemaURLAppendix;
        log.info((Object)("HttpSolrQueryService.lookupSchema - the url of getting the solr configure file is " + schemaURL));
        return new URL(schemaURL).openStream();
    }

    @Override
    public String getSolrServerVersion() {
        if (this.solrSpecVersion == null) {
            this.getHttpSolrServerVersion();
        }
        return this.solrSpecVersion;
    }

    private void getHttpSolrServerVersion() {
        String systemInfoUrlAppendix = Settings.getConfiguration().getString(SOLR_SYSTEMINFO_URLAPPENDIX);
        String systemInfoUrl = this.solrServerBaseURL + systemInfoUrlAppendix;
        try {
            Document doc = this.transformInputStreamToDoc(new URL(systemInfoUrl).openStream());
            NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate(SPEC_PATH, doc, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() > 0) {
                Node specNode = nodeList.item(0);
                this.solrSpecVersion = specNode.getFirstChild().getNodeValue();
            } else {
                this.solrSpecVersion = "Unknown";
            }
        }
        catch (Exception e) {
            log.error((Object)("HttpSolrQueryService.getHttpSolrServerVersion - can't get the solr specification version since " + e.getMessage()));
            this.solrSpecVersion = "Unknown";
        }
    }

    private Document transformInputStreamToDoc(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(input);
        return doc;
    }

    public boolean hasSolrDoc(Identifier id) throws ParserConfigurationException, SolrServerException, IOException, SAXException {
        boolean hasIt = false;
        if (id != null && id.getValue() != null && !id.getValue().trim().equals("")) {
            SolrParams query = EmbeddedSolrQueryService.buildIdQuery(id.getValue());
            QueryResponse response = this.httpSolrServer.query(query);
            hasIt = EmbeddedSolrQueryService.hasResult(response);
        }
        return hasIt;
    }
}

