/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.lib;

import arq.cmd.CmdException;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleTable;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.ByteBufferLib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Tuple;

public class DumpOps {
    public static void dump(Dataset ds) {
        DatasetGraphTDB dsg = (DatasetGraphTDB)ds.asDatasetGraph();
        NodeTupleTable nodeTupleTableTriples = dsg.getTripleTable().getNodeTupleTable();
        NodeTupleTable nodeTupleTableQuads = dsg.getQuadTable().getNodeTupleTable();
        if (nodeTupleTableTriples.getNodeTable() != nodeTupleTableQuads.getNodeTable()) {
            throw new CmdException("Different node tables for triples and quads");
        }
        NodeTable nodeTable = nodeTupleTableTriples.getNodeTable();
        HashSet<NodeTable> dumpedNodeTables = new HashSet<NodeTable>();
        System.out.print("## Node Table\n");
        DumpOps.dumpNodeTable(nodeTupleTableTriples.getNodeTable(), dumpedNodeTables);
        DumpOps.dumpNodeTable(nodeTupleTableQuads.getNodeTable(), dumpedNodeTables);
        DumpOps.dumpTupleIndexes(nodeTupleTableTriples.getTupleTable().getIndexes());
        DumpOps.dumpTupleIndexes(nodeTupleTableQuads.getTupleTable().getIndexes());
        System.out.print("## Prefix Table\n");
        DatasetPrefixesTDB prefixes = dsg.getPrefixes();
        NodeTupleTable pntt = prefixes.getNodeTupleTable();
        if (!dumpedNodeTables.contains(pntt.getNodeTable())) {
            DumpOps.dumpNodeTable(pntt.getNodeTable(), dumpedNodeTables);
            dumpedNodeTables.add(pntt.getNodeTable());
        }
        DumpOps.dumpTupleIndexes(prefixes.getNodeTupleTable().getTupleTable().getIndexes());
    }

    public static void dumpNodeTable(NodeTable nodeTable, Set<NodeTable> dumpedNodeTables) {
        if (dumpedNodeTables.contains(nodeTable)) {
            return;
        }
        Iterator<Pair<NodeId, Node>> iter = nodeTable.all();
        while (iter.hasNext()) {
            Pair<NodeId, Node> pair = iter.next();
            NodeId nid = (NodeId)pair.car();
            Node n = (Node)pair.cdr();
            String x = NodeFmtLib.serialize(n);
            System.out.printf("%016X %s\n", nid.getId(), x);
        }
        dumpedNodeTables.add(nodeTable);
    }

    public static void dumpTupleIndexes(TupleIndex[] tupleIndexes) {
        for (TupleIndex tIdx : tupleIndexes) {
            DumpOps.dumpTupleIndex(tIdx);
        }
    }

    public static void dumpTupleIndex(TupleIndex tIdx) {
        System.out.print("## " + tIdx.getMapping() + "\n");
        Iterator<Tuple<NodeId>> iter = tIdx.all();
        while (iter.hasNext()) {
            Tuple<NodeId> t = iter.next();
            System.out.print(t);
            System.out.print("\n");
        }
    }

    public static void dumpBlockMgr(PrintStream out, BlockMgr blkMgr) {
        try {
            for (int id = 0; id < 9999999 && blkMgr.valid(id); ++id) {
                Block blk = blkMgr.getRead(id);
                out.print("id=" + blk.getId() + "  ");
                ByteBufferLib.print((PrintStream)out, (ByteBuffer)blk.getByteBuffer());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dumpBPlusTree(PrintStream out, BPlusTree bpt) {
        IndentedWriter iw = new IndentedWriter((OutputStream)out);
        bpt.dump(iw);
    }

    public static void dumpBPlusTreeBlocks(BPlusTree bpt) {
        System.out.println("Data blocks");
        DumpOps.dumpBlockMgr(System.out, bpt.getRecordsMgr().getBlockMgr());
        System.out.println("Node blocks");
        DumpOps.dumpBlockMgr(System.out, bpt.getRecordsMgr().getBlockMgr());
    }

    public static void dumpNodeTupleTable(TupleTable tupleTable) {
        int N = tupleTable.getTupleLen();
        Object[] nodeIds = new NodeId[N];
        Arrays.fill(nodeIds, NodeId.NodeIdAny);
        Tuple t = Tuple.create((Object[])nodeIds);
        Iterator<Tuple<NodeId>> iter = tupleTable.find((Tuple<NodeId>)t);
        while (iter.hasNext()) {
            Tuple<NodeId> tuple = iter.next();
            System.out.print(tuple);
            System.out.print("\n");
        }
    }
}

