/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentIntersector;
import com.vividsolutions.jts.noding.SegmentString;

public class LineIntersectionAdder
implements SegmentIntersector {
    private boolean hasIntersection = false;
    private boolean hasProper = false;
    private boolean hasProperInterior = false;
    private boolean hasInterior = false;
    private Coordinate properIntersectionPoint = null;
    private LineIntersector li;
    private boolean isSelfIntersection;
    public int numIntersections = 0;
    public int numInteriorIntersections = 0;
    public int numProperIntersections = 0;
    public int numTests = 0;

    public static boolean isAdjacentSegments(int i1, int i2) {
        return Math.abs(i1 - i2) == 1;
    }

    public LineIntersectionAdder(LineIntersector li) {
        this.li = li;
    }

    public LineIntersector getLineIntersector() {
        return this.li;
    }

    public Coordinate getProperIntersectionPoint() {
        return this.properIntersectionPoint;
    }

    public boolean hasIntersection() {
        return this.hasIntersection;
    }

    public boolean hasProperIntersection() {
        return this.hasProper;
    }

    public boolean hasProperInteriorIntersection() {
        return this.hasProperInterior;
    }

    public boolean hasInteriorIntersection() {
        return this.hasInterior;
    }

    private boolean isTrivialIntersection(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && this.li.getIntersectionNum() == 1) {
            if (LineIntersectionAdder.isAdjacentSegments(segIndex0, segIndex1)) {
                return true;
            }
            if (e0.isClosed()) {
                int maxSegIndex = e0.size() - 1;
                if (segIndex0 == 0 && segIndex1 == maxSegIndex || segIndex1 == 0 && segIndex0 == maxSegIndex) {
                    return true;
                }
            }
        }
        return false;
    }

    public void processIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        ++this.numTests;
        Coordinate p00 = e0.getCoordinates()[segIndex0];
        Coordinate p01 = e0.getCoordinates()[segIndex0 + 1];
        Coordinate p10 = e1.getCoordinates()[segIndex1];
        Coordinate p11 = e1.getCoordinates()[segIndex1 + 1];
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection()) {
            ++this.numIntersections;
            if (this.li.isInteriorIntersection()) {
                ++this.numInteriorIntersections;
                this.hasInterior = true;
            }
            if (!this.isTrivialIntersection(e0, segIndex0, e1, segIndex1)) {
                this.hasIntersection = true;
                ((NodedSegmentString)e1).addIntersections(this.li, segIndex1, 1);
                if (this.li.isProper()) {
                    ++this.numProperIntersections;
                    this.hasProper = true;
                    this.hasProperInterior = true;
                }
            }
        }
    }

    public boolean isDone() {
        return false;
    }
}

