/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.logging.LogManager;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockReleaseFailedException;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;
import org.junit.Ignore;

public class LuceneJUnitResultFormatter
implements JUnitResultFormatter {
    private static final double ONE_SECOND = 1000.0;
    private static final NativeFSLockFactory lockFactory;
    private OutputStream out;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private String systemOutput = null;
    private String systemError = null;
    private ByteArrayOutputStream sb;
    private static final Lock lock;

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    public void setSystemError(String err) {
        this.systemError = err;
    }

    public synchronized void startTestSuite(JUnitTest suite) {
        if (this.out == null) {
            return;
        }
        this.sb = new ByteArrayOutputStream();
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.append("Testsuite: ");
        this.append(suite.getName());
        this.append(StringUtils.LINE_SEP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endTestSuite(JUnitTest suite) {
        this.append("Tests run: ");
        this.append(suite.runCount());
        this.append(", Failures: ");
        this.append(suite.failureCount());
        this.append(", Errors: ");
        this.append(suite.errorCount());
        this.append(", Time elapsed: ");
        this.append(this.numberFormat.format((double)suite.getRunTime() / 1000.0));
        this.append(" sec");
        this.append(StringUtils.LINE_SEP);
        this.append(StringUtils.LINE_SEP);
        if (this.systemOutput != null && this.systemOutput.length() > 0) {
            this.append("------------- Standard Output ---------------").append(StringUtils.LINE_SEP).append(this.systemOutput).append("------------- ---------------- ---------------").append(StringUtils.LINE_SEP);
        }
        try {
            Class<?> clazz = Class.forName(suite.getName());
            Ignore ignore = clazz.getAnnotation(Ignore.class);
            if (ignore != null) {
                if (this.systemError == null) {
                    this.systemError = "";
                }
                this.systemError = this.systemError + "NOTE: Ignoring test class '" + clazz.getSimpleName() + "': " + ignore.value() + StringUtils.LINE_SEP;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.systemError != null && this.systemError.length() > 0) {
            this.append("------------- Standard Error -----------------").append(StringUtils.LINE_SEP).append(this.systemError).append("------------- ---------------- ---------------").append(StringUtils.LINE_SEP);
        }
        if (this.out != null) {
            try {
                lock.obtain(5000L);
                try {
                    this.sb.writeTo(this.out);
                    this.out.flush();
                }
                finally {
                    try {
                        lock.release();
                    }
                    catch (LockReleaseFailedException e) {}
                }
            }
            catch (IOException e) {
                throw new RuntimeException("unable to write results", e);
            }
            finally {
                if (this.out != System.out && this.out != System.err) {
                    FileUtils.close((OutputStream)this.out);
                }
            }
        }
    }

    public void startTest(Test test) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable error) {
        this.formatError("\tCaused an ERROR", test, error);
    }

    protected String formatTest(Test test) {
        if (test == null) {
            return "Null Test: ";
        }
        return "Testcase: " + test.toString() + ":";
    }

    protected synchronized void formatError(String type, Test test, Throwable error) {
        if (test != null) {
            this.endTest(test);
        }
        this.append(this.formatTest(test) + type);
        this.append(StringUtils.LINE_SEP);
        this.append(error.getMessage());
        this.append(StringUtils.LINE_SEP);
        String strace = JUnitTestRunner.getFilteredTrace((Throwable)error);
        this.append(strace);
        this.append(StringUtils.LINE_SEP);
        this.append(StringUtils.LINE_SEP);
    }

    public LuceneJUnitResultFormatter append(String s) {
        if (s == null) {
            s = "(null)";
        }
        try {
            this.sb.write(s.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public LuceneJUnitResultFormatter append(long l) {
        return this.append(Long.toString(l));
    }

    static {
        File lockDir = new File(System.getProperty("tests.lockdir", System.getProperty("java.io.tmpdir")), "lucene_junit_lock");
        lockDir.mkdirs();
        if (!lockDir.exists()) {
            throw new RuntimeException("Could not make Lock directory:" + lockDir);
        }
        try {
            lockFactory = new NativeFSLockFactory(lockDir);
            lock = lockFactory.makeLock("junit_lock");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

