/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities.namevalue.impl;

import gov.loc.repository.bagit.utilities.namevalue.NameValueReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NameValueReaderImpl
implements NameValueReader {
    private static final Log log = LogFactory.getLog(NameValueReaderImpl.class);
    private Deque<String> lines = new ArrayDeque<String>();
    private String type;

    public NameValueReaderImpl(String encoding, InputStream in, String type) {
        this.type = type;
        InputStreamReader fr = null;
        BufferedReader reader = null;
        try {
            fr = new InputStreamReader(in, encoding);
            reader = new BufferedReader(fr);
            String line = reader.readLine();
            while (line != null) {
                this.lines.addLast(line);
                line = reader.readLine();
            }
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fr);
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fr);
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public boolean hasNext() {
        return !this.lines.isEmpty();
    }

    @Override
    public NameValueReader.NameValue next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String line = this.lines.removeFirst();
        String[] splitString = line.split(" *: *", 2);
        String name = splitString[0];
        String value = null;
        if (splitString.length == 2) {
            value = splitString[1].trim();
            while (!this.lines.isEmpty() && this.lines.getFirst().matches("^( |\\t)+.+$")) {
                value = value + " " + this.lines.removeFirst().replaceAll("^( |\\t)+", "");
            }
        }
        NameValueReader.NameValue ret = new NameValueReader.NameValue(name, value);
        log.debug((Object)MessageFormat.format("Read from {0}: {1}", this.type, ret.toString()));
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

