/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.ConditionInterface;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.Entity;

public class Join
implements ConditionInterface {
    private Entity entity1 = null;
    private Entity entity2 = null;
    private Attribute attribute1 = null;
    private Attribute attribute2 = null;

    public Join(Entity entity1, Attribute attribute1, Entity entity2, Attribute attribute2) {
        this.entity1 = entity1;
        this.entity2 = entity2;
        this.attribute1 = attribute1;
        this.attribute2 = attribute2;
    }

    public void setLeft(Entity entity1, Attribute attribute1) {
        this.entity1 = entity1;
        this.attribute1 = attribute1;
    }

    public void setRight(Entity entity2, Attribute attribute2) {
        this.entity2 = entity2;
        this.attribute2 = attribute2;
    }

    public boolean isLeftSet() {
        return this.entity1 != null && this.attribute1 != null;
    }

    public boolean isRightSet() {
        return this.entity2 != null && this.attribute2 != null;
    }

    @Override
    public String toSQLString() throws UnWellFormedQueryException {
        if (this.entity1 == null || this.entity2 == null) {
            throw new UnWellFormedQueryException("The entity in join part couldn't be null");
        }
        if (this.attribute1 == null || this.attribute2 == null) {
            throw new UnWellFormedQueryException("The attribute in join part couldn't be null");
        }
        String entity1Name = null;
        String attribute1Name = null;
        String entity2Name = null;
        String attribute2Name = null;
        try {
            entity1Name = DataManager.getDBTableName(this.entity1);
            entity2Name = DataManager.getDBTableName(this.entity2);
            attribute1Name = DataManager.getDBFieldName(this.entity1, this.attribute1);
            attribute2Name = DataManager.getDBFieldName(this.entity2, this.attribute2);
        }
        catch (Exception sql) {
            sql.printStackTrace();
            System.out.println("Entity or Atribute name is null " + sql.getMessage());
        }
        if (entity1Name == null || entity2Name == null || entity1Name.trim().equals("") || entity2Name.trim().equals("")) {
            throw new UnWellFormedQueryException("The entity name in join part couldn't be null");
        }
        if (attribute2Name == null || attribute1Name == null || attribute1Name.trim().equals("") || attribute2Name.trim().equals("")) {
            throw new UnWellFormedQueryException("The attribute name in join part couldn't be null");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(entity1Name);
        sql.append(".");
        sql.append(attribute1Name);
        sql.append(" ");
        sql.append("=");
        sql.append(" ");
        sql.append(entity2Name);
        sql.append(".");
        sql.append(attribute2Name);
        return sql.toString();
    }
}

