/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.CookieNotFoundException;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieParser {
    private HttpServletRequest req;
    private Hashtable cookieJar = new Hashtable();

    public CookieParser(HttpServletRequest req) {
        this.req = req;
        this.parseCookies();
    }

    public boolean getBooleanCookie(String name) throws CookieNotFoundException {
        return new Boolean(this.getStringCookie(name));
    }

    public boolean getBooleanCookie(String name, boolean def) {
        try {
            return this.getBooleanCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public byte getByteCookie(String name) throws CookieNotFoundException, NumberFormatException {
        return Byte.parseByte(this.getStringCookie(name));
    }

    public byte getByteCookie(String name, byte def) {
        try {
            return this.getByteCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public char getCharCookie(String name) throws CookieNotFoundException {
        String param = this.getStringCookie(name);
        if (param.length() == 0) {
            throw new CookieNotFoundException(String.valueOf(name) + " is empty string");
        }
        return param.charAt(0);
    }

    public char getCharCookie(String name, char def) {
        try {
            return this.getCharCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public double getDoubleCookie(String name) throws CookieNotFoundException, NumberFormatException {
        return new Double(this.getStringCookie(name));
    }

    public double getDoubleCookie(String name, double def) {
        try {
            return this.getDoubleCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public float getFloatCookie(String name) throws CookieNotFoundException, NumberFormatException {
        return new Float(this.getStringCookie(name)).floatValue();
    }

    public float getFloatCookie(String name, float def) {
        try {
            return this.getFloatCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public int getIntCookie(String name) throws CookieNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringCookie(name));
    }

    public int getIntCookie(String name, int def) {
        try {
            return this.getIntCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public long getLongCookie(String name) throws CookieNotFoundException, NumberFormatException {
        return Long.parseLong(this.getStringCookie(name));
    }

    public long getLongCookie(String name, long def) {
        try {
            return this.getLongCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public short getShortCookie(String name) throws CookieNotFoundException, NumberFormatException {
        return Short.parseShort(this.getStringCookie(name));
    }

    public short getShortCookie(String name, short def) {
        try {
            return this.getShortCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public String getStringCookie(String name) throws CookieNotFoundException {
        String value = (String)this.cookieJar.get(name);
        if (value == null) {
            throw new CookieNotFoundException(String.valueOf(name) + " not found");
        }
        return value;
    }

    public String getStringCookie(String name, String def) {
        try {
            return this.getStringCookie(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    void parseCookies() {
        Cookie[] cookies = this.req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                String name = cookies[i].getName();
                String value = cookies[i].getValue();
                this.cookieJar.put(name, value);
                ++i;
            }
        }
    }
}

