/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public abstract class RemoteHttpServlet
extends HttpServlet
implements Remote {
    protected Registry registry;

    protected void bind() {
        try {
            this.registry = LocateRegistry.getRegistry(this.getRegistryPort());
            this.registry.list();
        }
        catch (Exception exception) {
            this.registry = null;
        }
        if (this.registry == null) {
            try {
                this.registry = LocateRegistry.createRegistry(this.getRegistryPort());
            }
            catch (Exception e) {
                this.log("Could not get or create RMI registry on port " + this.getRegistryPort() + ": " + e.getMessage());
                return;
            }
        }
        try {
            this.registry.rebind(this.getRegistryName(), this);
        }
        catch (Exception e) {
            this.log("Could not bind to RMI registry: " + e.getMessage());
            return;
        }
    }

    public void destroy() {
        this.unbind();
    }

    protected String getRegistryName() {
        String name = this.getInitParameter("registryName");
        if (name != null) {
            return name;
        }
        return this.getClass().getName();
    }

    protected int getRegistryPort() {
        try {
            return Integer.parseInt(this.getInitParameter("registryPort"));
        }
        catch (NumberFormatException numberFormatException) {
            return 1099;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            UnicastRemoteObject.exportObject(this);
            this.bind();
        }
        catch (RemoteException e) {
            this.log("Problem binding to RMI registry: " + e.getMessage());
        }
    }

    protected void unbind() {
        try {
            if (this.registry != null) {
                this.registry.unbind(this.getRegistryName());
            }
        }
        catch (Exception e) {
            this.log("Problem unbinding from RMI registry: " + e.getMessage());
        }
    }
}

