/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.Keywords;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNKeywords;

public class Keywordsremove
extends Keywords {
    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        super.execute(iSVNClientAdapter);
        this.log("Svn : Keywordsremove");
        if (this.file != null) {
            try {
                iSVNClientAdapter.removeKeywords(this.file, this.keywords);
            }
            catch (SVNClientException sVNClientException) {
                throw new BuildException("Can't remove keywords on file " + this.file.toString(), (Throwable)sVNClientException);
            }
        } else if (this.dir != null) {
            try {
                iSVNClientAdapter.removeKeywords(this.dir, this.keywords);
            }
            catch (SVNClientException sVNClientException) {
                throw new BuildException("Can't remove keywords on directory " + this.dir.toString(), (Throwable)sVNClientException);
            }
        } else if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.keywordsRemove(fileSet, this.keywords);
            }
        }
    }

    private void keywordsRemove(FileSet fileSet, SVNKeywords sVNKeywords) throws BuildException {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            try {
                this.svnClient.removeKeywords(file2, sVNKeywords);
                continue;
            }
            catch (SVNClientException sVNClientException) {
                throw new BuildException("Can't set keywords on file " + file2.toString(), (Throwable)sVNClientException);
            }
        }
    }
}

