/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.ecoinformatics.export.HtmlToPdf;

public class HtmlToPdfTest
extends TestCase {
    public HtmlToPdfTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void initialize() {
        HtmlToPdfTest.assertTrue((boolean)true);
    }

    public void testExport() {
        try {
            String srcPath = "src/test/resources/";
            String workingPath = "build/";
            String emlFileName = "eml-sample";
            String emlFileExtension = ".xml";
            String emlFile = srcPath + emlFileName + emlFileExtension;
            String xslFile = "style/eml/eml.xsl";
            String htmlFile = workingPath + emlFileName + ".html";
            File cssDir = new File(workingPath + "default");
            if (!cssDir.exists()) {
                cssDir.mkdir();
            }
            File cssFile = new File("default.css");
            File targetCssFile = new File(cssDir, cssFile.getName());
            IOUtils.copy((InputStream)new FileInputStream(cssFile), (OutputStream)new FileOutputStream(targetCssFile));
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(new File(xslFile)));
            transformer.clearParameters();
            transformer.setParameter("href_path_extension", ".html");
            transformer.setParameter("package_id", "test.1.1");
            transformer.setParameter("package_index_name", "metadata");
            transformer.setParameter("qformat", "default");
            transformer.setParameter("entitystyle", "default");
            transformer.setParameter("stylePath", ".");
            transformer.setParameter("displaymodule", "printall");
            transformer.transform(new StreamSource(new File(emlFile)), new StreamResult(new File(htmlFile)));
            String pdfFile = workingPath + emlFileName + ".pdf";
            HtmlToPdf.export(htmlFile, pdfFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            HtmlToPdfTest.fail((String)e.getMessage());
        }
    }
}

