/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import com.oreilly.servlet.multipart.MacBinaryDecoderOutputStream;
import com.oreilly.servlet.multipart.Part;
import com.oreilly.servlet.multipart.PartInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;

public class FilePart
extends Part {
    private String fileName;
    private String filePath;
    private String contentType;
    private PartInputStream partInput;

    FilePart(String name, ServletInputStream in, String boundary, String contentType, String fileName, String filePath) throws IOException {
        super(name);
        this.fileName = fileName;
        this.filePath = filePath;
        this.contentType = contentType;
        this.partInput = new PartInputStream(in, boundary);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    public boolean isFile() {
        return true;
    }

    long write(OutputStream out) throws IOException {
        int read;
        if (this.contentType.equals("application/x-macbinary")) {
            out = new MacBinaryDecoderOutputStream(out);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this.partInput.read(buf)) != -1) {
            out.write(buf, 0, read);
            size += (long)read;
        }
        return size;
    }

    public long writeTo(File fileOrDirectory) throws IOException {
        OutputStream fileOut;
        long written;
        block4: {
            written = 0L;
            fileOut = null;
            try {
                if (this.fileName == null) break block4;
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                written = this.write(fileOut);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (fileOut != null) {
                    fileOut.close();
                }
                throw throwable;
            }
        }
        Object var6_5 = null;
        if (fileOut != null) {
            fileOut.close();
        }
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this.fileName != null) {
            size = this.write(out);
        }
        return size;
    }
}

