/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.List;
import org.jdom.Comment;
import org.jdom.ContentList;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.ProcessingInstruction;
import org.jdom.filter.Filter;

public class Document
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Document.java,v $ $Revision: 1.55 $ $Date: 2002/03/28 11:08:12 $ $Name: jdom_1_0_b8 $";
    protected ContentList content = new ContentList(this);
    protected DocType docType;

    public Document() {
    }

    public Document(List content) {
        this(content, null);
    }

    public Document(List newContent, DocType docType) {
        this.setContent(newContent);
        this.setDocType(docType);
    }

    public Document(Element rootElement) {
        this(rootElement, null);
    }

    public Document(Element rootElement, DocType docType) {
        if (rootElement != null) {
            this.setRootElement(rootElement);
        }
        this.setDocType(docType);
    }

    public Document addContent(Comment comment) {
        this.content.add(comment);
        return this;
    }

    public Document addContent(ProcessingInstruction pi) {
        this.content.add(pi);
        return this;
    }

    public Object clone() {
        Document doc = null;
        try {
            doc = (Document)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        if (this.docType != null) {
            doc.docType = (DocType)this.docType.clone();
        }
        doc.content = new ContentList(doc);
        int i = 0;
        while (i < this.content.size()) {
            Object obj = this.content.get(i);
            if (obj instanceof Element) {
                Element element = (Element)((Element)obj).clone();
                doc.content.add(element);
            } else if (obj instanceof Comment) {
                Comment comment = (Comment)((Comment)obj).clone();
                doc.content.add(comment);
            } else if (obj instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)((ProcessingInstruction)obj).clone();
                doc.content.add(pi);
            }
            ++i;
        }
        return doc;
    }

    public Element detachRootElement() {
        int index = this.content.indexOfFirstElement();
        if (index < 0) {
            return null;
        }
        return (Element)this.removeContent(index);
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public List getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    public List getContent(Filter filter) {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content.getView(filter);
    }

    public DocType getDocType() {
        return this.docType;
    }

    public Element getRootElement() {
        int index = this.content.indexOfFirstElement();
        if (index < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(index);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private Object removeContent(int index) {
        return this.content.remove(index);
    }

    public boolean removeContent(Comment comment) {
        return this.content.remove(comment);
    }

    public boolean removeContent(ProcessingInstruction pi) {
        return this.content.remove(pi);
    }

    public Document setContent(List newContent) {
        this.content.clearAndSet(newContent);
        return this;
    }

    public Document setDocType(DocType docType) {
        if (docType != null) {
            if (docType.getDocument() != null) {
                throw new IllegalAddException(this, docType, "The docType already is attached to a document");
            }
            docType.setDocument(this);
        }
        if (this.docType != null) {
            this.docType.setDocument(null);
        }
        this.docType = docType;
        return this;
    }

    public Document setRootElement(Element rootElement) {
        int index = this.content.indexOfFirstElement();
        if (index < 0) {
            this.content.add(rootElement);
        } else {
            this.content.set(index, rootElement);
        }
        return this;
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer().append("[Document: ");
        if (this.docType != null) {
            stringForm.append(this.docType.toString()).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        Element rootElement = this.getRootElement();
        if (rootElement != null) {
            stringForm.append("Root is ").append(rootElement.toString());
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return stringForm.toString();
    }
}

