/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.ParameterNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.servlet.ServletRequest;

public class ParameterParser {
    private ServletRequest req;
    private String encoding;

    public ParameterParser(ServletRequest req) {
        this.req = req;
    }

    public boolean getBooleanParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        String value = this.getStringParameter(name).toLowerCase();
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
            return false;
        }
        throw new NumberFormatException("Parameter " + name + " value " + value + " is not a boolean");
    }

    public boolean getBooleanParameter(String name, boolean def) {
        try {
            return this.getBooleanParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public byte getByteParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Byte.parseByte(this.getStringParameter(name));
    }

    public byte getByteParameter(String name, byte def) {
        try {
            return this.getByteParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public char getCharParameter(String name) throws ParameterNotFoundException {
        String param = this.getStringParameter(name);
        if (param.length() == 0) {
            throw new ParameterNotFoundException(String.valueOf(name) + " is empty string");
        }
        return param.charAt(0);
    }

    public char getCharParameter(String name, char def) {
        try {
            return this.getCharParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public double getDoubleParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return new Double(this.getStringParameter(name));
    }

    public double getDoubleParameter(String name, double def) {
        try {
            return this.getDoubleParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public float getFloatParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return new Float(this.getStringParameter(name)).floatValue();
    }

    public float getFloatParameter(String name, float def) {
        try {
            return this.getFloatParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public int getIntParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringParameter(name));
    }

    public int getIntParameter(String name, int def) {
        try {
            return this.getIntParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public long getLongParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Long.parseLong(this.getStringParameter(name));
    }

    public long getLongParameter(String name, long def) {
        try {
            return this.getLongParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public String[] getMissingParameters(String[] required) {
        Vector<String> missing = new Vector<String>();
        int i = 0;
        while (i < required.length) {
            String val = this.getStringParameter(required[i], null);
            if (val == null) {
                missing.addElement(required[i]);
            }
            ++i;
        }
        if (missing.size() == 0) {
            return null;
        }
        Object[] ret = new String[missing.size()];
        missing.copyInto(ret);
        return ret;
    }

    public short getShortParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Short.parseShort(this.getStringParameter(name));
    }

    public short getShortParameter(String name, short def) {
        try {
            return this.getShortParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public String getStringParameter(String name) throws ParameterNotFoundException {
        String[] values = this.req.getParameterValues(name);
        if (values == null) {
            throw new ParameterNotFoundException(String.valueOf(name) + " not found");
        }
        if (values[0].length() == 0) {
            throw new ParameterNotFoundException(String.valueOf(name) + " was empty");
        }
        if (this.encoding == null) {
            return values[0];
        }
        try {
            return new String(values[0].getBytes("8859_1"), this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return values[0];
        }
    }

    public String getStringParameter(String name, String def) {
        try {
            return this.getStringParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        new String("".getBytes("8859_1"), encoding);
        this.encoding = encoding;
    }
}

