/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.emltest;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.ecoinformatics.eml.EMLValidator;

public class EMLValidatorTest
extends TestCase {
    private static final String TEST_DIR = "./src/test/resources";
    private static final String INVALID_DIR = "./src/test/resources/invalidEML";

    public EMLValidatorTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EMLValidatorTest("initialize"));
        suite.addTest((Test)new EMLValidatorTest("testValidDocs"));
        suite.addTest((Test)new EMLValidatorTest("testInvalidDocs"));
        suite.addTest((Test)new EMLValidatorTest("testStringInput"));
        return suite;
    }

    public void initialize() {
        EMLValidatorTest.assertTrue((boolean)true);
    }

    public void testValidDocs() {
        File testDir = new File(TEST_DIR);
        ArrayList fileList = this.getXmlFiles(testDir);
        for (int i = 0; i < fileList.size(); ++i) {
            File testFile = (File)fileList.get(i);
            try {
                System.err.println("Validating file: " + testFile.getName());
                EMLValidator validator = new EMLValidator(testFile);
                boolean isValid = validator.validate();
                if (isValid) continue;
                for (String e : validator.getErrors()) {
                    System.err.println(e);
                }
                EMLValidatorTest.fail((String)("Validator: NOT valid: " + testFile.getPath()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                EMLValidatorTest.fail((String)("Validator exception!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
            }
        }
    }

    public void testInvalidDocs() {
        int failures = 0;
        File invalidDir = new File(INVALID_DIR);
        ArrayList invalidList = this.getXmlFiles(invalidDir);
        int invalidFileCount = invalidList.size();
        System.err.println("Checking invalid files: " + invalidFileCount);
        for (int i = 0; i < invalidFileCount; ++i) {
            File invalidFile = (File)invalidList.get(i);
            System.err.println("Invalidating file: " + invalidFile.getName());
            try {
                EMLValidator validator = new EMLValidator(invalidFile);
                boolean isValid = validator.validate();
                if (!isValid) {
                    System.err.println("    Invalid, which is right.");
                    ++failures;
                    continue;
                }
                System.err.println("    Valid, which it shouldn't be.");
                EMLValidatorTest.fail((String)("Validator: found valid when should not be: " + invalidFile.getPath()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                EMLValidatorTest.fail((String)("Validator exception!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
            }
        }
        if (failures != invalidFileCount) {
            System.err.println(failures + "/" + invalidFileCount + " failures in directory.");
            EMLValidatorTest.fail((String)"Error: An error should have been thrown for all invalid files.");
        }
    }

    public void testStringInput() {
        File testDir = new File(TEST_DIR);
        File testFile = new File(TEST_DIR, "eml-sample.xml");
        try {
            System.err.println("Validating string input for: " + testFile.getName());
            String emltext = new String(Files.readAllBytes(Paths.get(testFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
            EMLValidator validator = new EMLValidator(emltext);
            boolean isValid = validator.validate();
            if (!isValid) {
                for (String e : validator.getErrors()) {
                    System.err.println(e);
                }
                EMLValidatorTest.fail((String)("Validator: NOT valid: " + testFile.getPath()));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            EMLValidatorTest.fail((String)("Validator exception!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
        }
    }

    private ArrayList getXmlFiles(File directory) {
        String[] files = directory.list();
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            File currentFile = new File(directory, filename);
            if (!currentFile.isFile() || !filename.endsWith(".xml") || filename.startsWith("stmml")) continue;
            fileList.add(currentFile);
        }
        return fileList;
    }
}

