/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.modify.UpdateSink;
import com.hp.hpl.jena.sparql.modify.UsingList;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAccSink;
import com.hp.hpl.jena.sparql.modify.request.UpdateWithUsing;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateException;

public class UsingUpdateSink
implements UpdateSink {
    private final UpdateSink sink;
    private final UsingList usingList;

    public UsingUpdateSink(UpdateSink sink, UsingList usingList) {
        this.sink = sink;
        this.usingList = usingList;
    }

    @Override
    public void send(Update update2) {
        if (null != this.usingList && this.usingList.usingIsPresent() && update2 instanceof UpdateWithUsing) {
            UpdateWithUsing upu = (UpdateWithUsing)update2;
            if (upu.getUsing().size() != 0 || upu.getUsingNamed().size() != 0 || upu.getWithIRI() != null) {
                throw new UpdateException("SPARQL Update: Protocol using-graph-uri or using-named-graph-uri present where update request has USING, USING NAMED or WITH");
            }
            for (Node node : this.usingList.getUsing()) {
                upu.addUsing(node);
            }
            for (Node node : this.usingList.getUsingNamed()) {
                upu.addUsingNamed(node);
            }
        }
        this.sink.send(update2);
    }

    @Override
    public QuadDataAccSink createInsertDataSink() {
        return this.sink.createInsertDataSink();
    }

    @Override
    public QuadDataAccSink createDeleteDataSink() {
        return this.sink.createDeleteDataSink();
    }

    @Override
    public void flush() {
        this.sink.flush();
    }

    @Override
    public void close() {
        this.sink.close();
    }

    @Override
    public Prologue getPrologue() {
        return this.sink.getPrologue();
    }
}

