/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileBase;
import org.apache.jena.riot.system.ParserProfileChecker;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.riot.writer.WriterConst;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;

public class RiotLib {
    private static final String bNodeLabelStart = "_:";
    private static final boolean skolomizedBNodes = ARQ.isTrue(ARQ.constantBNodeLabels);
    private static ParserProfile profile = RiotLib.profile(RDFLanguages.TURTLE, null, null);

    public static Node createIRIorBNode(String iri2) {
        if (RiotLib.isBNodeIRI(iri2)) {
            String s = iri2.substring(bNodeLabelStart.length());
            Node n = NodeFactory.createAnon((AnonId)new AnonId(s));
            return n;
        }
        return NodeFactory.createURI((String)iri2);
    }

    public static boolean isBNodeIRI(String iri2) {
        return skolomizedBNodes && iri2.startsWith(bNodeLabelStart);
    }

    public static Node parse(String string) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(string);
        if (!tokenizer.hasNext()) {
            return null;
        }
        Token t = tokenizer.next();
        Node n = profile.create(null, t);
        if (tokenizer.hasNext()) {
            Log.warn(RiotLib.class, "String has more than one token in it: " + string);
        }
        return n;
    }

    public static ParserProfile profile(Lang lang, String baseIRI) {
        return RiotLib.profile(lang, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler());
    }

    public static ParserProfile profile(Lang lang, String baseIRI, ErrorHandler handler) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang) || RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            boolean checking = SysRIOT.strictMode;
            return RiotLib.profile(baseIRI, false, checking, handler);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            return RiotLib.profile(baseIRI, false, true, handler);
        }
        return RiotLib.profile(baseIRI, true, true, handler);
    }

    public static ParserProfile profile(String baseIRI, boolean resolveIRIs, boolean checking, ErrorHandler handler) {
        LabelToNode labelToNode = SyntaxLabels.createLabelToNode();
        Prologue prologue = resolveIRIs ? new Prologue(PrefixMapFactory.createForInput(), IRIResolver.create(baseIRI)) : new Prologue(PrefixMapFactory.createForInput(), IRIResolver.createNoResolve());
        if (checking) {
            return new ParserProfileChecker(prologue, handler, labelToNode);
        }
        return new ParserProfileBase(prologue, handler, labelToNode);
    }

    public static Collection<Triple> triplesOfSubject(Graph graph, Node subj) {
        return RiotLib.triples(graph, subj, Node.ANY, Node.ANY);
    }

    public static List<Triple> triples(Graph graph, Node s, Node p, Node o) {
        ArrayList<Triple> acc = new ArrayList<Triple>();
        RiotLib.accTriples(acc, graph, s, p, o);
        return acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countTriples(Graph graph, Node s, Node p, Node o) {
        ExtendedIterator iter = graph.find(s, p, o);
        try {
            long l = Iter.count(iter);
            return l;
        }
        finally {
            iter.close();
        }
    }

    public static void accTriples(Collection<Triple> acc, Graph graph, Node s, Node p, Node o) {
        ExtendedIterator iter = graph.find(s, p, o);
        while (iter.hasNext()) {
            acc.add((Triple)iter.next());
        }
        iter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Triple triple1(Graph graph, Node s, Node p, Node o) {
        ExtendedIterator iter = graph.find(s, p, o);
        try {
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple t = (Triple)iter.next();
            if (iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple triple = t;
            return triple;
        }
        finally {
            iter.close();
        }
    }

    public static boolean strSafeFor(String str2, char ch) {
        return str2.indexOf(ch) == -1;
    }

    public static void writeBase(IndentedWriter out, String base) {
        if (base != null) {
            out.print("@base ");
            out.pad(15);
            out.print("<");
            out.print(base);
            out.print(">");
            out.print(" .");
            out.println();
        }
    }

    public static void writePrefixes(IndentedWriter out, PrefixMap prefixMap) {
        if (prefixMap != null && !prefixMap.isEmpty()) {
            for (Map.Entry<String, String> e2 : prefixMap.getMappingCopyStr().entrySet()) {
                out.print("@prefix ");
                out.print(e2.getKey());
                out.print(": ");
                out.pad(15);
                out.print("<");
                out.print(e2.getValue());
                out.print(">");
                out.print(" .");
                out.println();
            }
        }
    }

    public static DatasetGraph dataset(Graph graph) {
        return DatasetGraphFactory.createOneGraph(graph);
    }

    public static PrefixMap prefixMap(DatasetGraph dsg) {
        return PrefixMapFactory.create(dsg.getDefaultGraph().getPrefixMapping());
    }

    private static int calcWidth(PrefixMap prefixMap, String baseURI, Node p) {
        if (!prefixMap.contains(WriterConst.rdfNS) && WriterConst.RDF_type.equals((Object)p)) {
            return 1;
        }
        String x = prefixMap.abbreviate(p.getURI());
        if (x == null) {
            return p.getURI().length() + 2;
        }
        return x.length();
    }

    public static int calcWidth(PrefixMap prefixMap, String baseURI, Collection<Node> nodes, int minWidth, int maxWidth) {
        Node prev = null;
        int nodeMaxWidth = minWidth;
        for (Node n : nodes) {
            int len;
            if (prev != null && prev.equals((Object)n) || (len = RiotLib.calcWidth(prefixMap, baseURI, n)) > maxWidth) continue;
            if (nodeMaxWidth < len) {
                nodeMaxWidth = len;
            }
            prev = n;
        }
        return nodeMaxWidth;
    }

    public static int calcWidthTriples(PrefixMap prefixMap, String baseURI, Collection<Triple> triples, int minWidth, int maxWidth) {
        Node prev = null;
        int nodeMaxWidth = minWidth;
        for (Triple triple : triples) {
            int len;
            Node n = triple.getPredicate();
            if (prev != null && prev.equals((Object)n) || (len = RiotLib.calcWidth(prefixMap, baseURI, n)) > maxWidth) continue;
            if (nodeMaxWidth < len) {
                nodeMaxWidth = len;
            }
            prev = n;
        }
        return nodeMaxWidth;
    }

    public static IndentedWriter create(Writer writer) {
        return new IndentedWriterWriter(writer);
    }

    public static PrefixMap prefixMap(Graph graph) {
        return PrefixMapFactory.create(graph.getPrefixMapping());
    }

    public static WriterGraphRIOTBase adapter(WriterDatasetRIOT writer) {
        return new WriterAdapter(writer);
    }

    static {
        PrefixMap pmap = profile.getPrologue().getPrefixMap();
        pmap.add("rdf", ARQConstants.rdfPrefix);
        pmap.add("rdfs", ARQConstants.rdfsPrefix);
        pmap.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        pmap.add("owl", ARQConstants.owlPrefix);
        pmap.add("fn", "http://www.w3.org/2005/xpath-functions#");
        pmap.add("op", "http://www.w3.org/2005/xpath-functions#");
        pmap.add("ex", "http://example/ns#");
        pmap.add("", "http://example/");
    }

    private static class WriterAdapter
    extends WriterGraphRIOTBase {
        private WriterDatasetRIOT writer;

        WriterAdapter(WriterDatasetRIOT writer) {
            this.writer = writer;
        }

        @Override
        public Lang getLang() {
            return this.writer.getLang();
        }

        @Override
        public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
            this.writer.write(out, RiotLib.dataset(graph), prefixMap, baseURI, context);
        }

        @Override
        public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
            this.writer.write(out, RiotLib.dataset(graph), prefixMap, baseURI, context);
        }
    }

    private static class IndentedWriterWriter
    extends IndentedWriter {
        IndentedWriterWriter(Writer w) {
            super(w);
        }
    }
}

