/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.lang.UpdateParser;
import com.hp.hpl.jena.sparql.modify.UpdateRequestSink;
import com.hp.hpl.jena.sparql.modify.UpdateSink;
import com.hp.hpl.jena.sparql.modify.UsingList;
import com.hp.hpl.jena.sparql.modify.UsingUpdateSink;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;

public class UpdateFactory {
    public static UpdateRequest create() {
        return new UpdateRequest();
    }

    public static UpdateRequest create(String string) {
        return UpdateFactory.create(string, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest create(String string, Syntax syntax) {
        return UpdateFactory.create(string, null, syntax);
    }

    public static UpdateRequest create(String string, String baseURI) {
        return UpdateFactory.create(string, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest create(String string, String baseURI, Syntax syntax) {
        UpdateRequest request = new UpdateRequest();
        UpdateFactory.make(request, string, baseURI, syntax);
        return request;
    }

    private static void make(UpdateRequest request, String input, String baseURI, Syntax syntax) {
        UpdateParser parser = UpdateFactory.setupParser(request, baseURI, syntax);
        parser.parse((UpdateSink)new UpdateRequestSink(request), input);
    }

    public static void parse(UpdateRequest request, String updateString) {
        UpdateFactory.make(request, updateString, null, Syntax.defaultUpdateSyntax);
    }

    public static void parse(UpdateRequest request, String updateString, Syntax syntax) {
        UpdateFactory.make(request, updateString, null, syntax);
    }

    public static void parse(UpdateRequest request, String updateString, String baseURI) {
        UpdateFactory.make(request, updateString, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static void parse(UpdateRequest request, String updateString, String baseURI, Syntax syntax) {
        UpdateFactory.make(request, updateString, baseURI, syntax);
    }

    protected static UpdateParser setupParser(Prologue prologue, String baseURI, Syntax syntax) {
        if (syntax != Syntax.syntaxSPARQL_11 && syntax != Syntax.syntaxARQ) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing update: " + syntax);
        }
        UpdateParser parser = UpdateParser.createParser(syntax);
        if (parser == null) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing update: " + syntax);
        }
        if (prologue.getResolver() == null) {
            try {
                baseURI = IRIResolver.chooseBaseURI((String)baseURI);
            }
            catch (Exception ex) {
                baseURI = "http://localhost/defaultBase#";
            }
            prologue.setResolver(new IRIResolver(baseURI));
        }
        return parser;
    }

    public static UpdateRequest read(UsingList usingList, String fileName) {
        return UpdateFactory.read(usingList, fileName, null, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(String fileName) {
        return UpdateFactory.read(fileName, null, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(String fileName, Syntax syntax) {
        return UpdateFactory.read(fileName, null, syntax);
    }

    public static UpdateRequest read(UsingList usingList, String fileName, Syntax syntax) {
        return UpdateFactory.read(usingList, fileName, null, syntax);
    }

    public static UpdateRequest read(String fileName, String baseURI, Syntax syntax) {
        return UpdateFactory.read(null, fileName, baseURI, syntax);
    }

    public static UpdateRequest read(UsingList usingList, String fileName, String baseURI, Syntax syntax) {
        InputStream in = null;
        if (fileName.equals("-")) {
            in = System.in;
        } else {
            in = IO.openFile(fileName);
            if (in == null) {
                throw new UpdateException("File could not be opened: " + fileName);
            }
        }
        return UpdateFactory.read(usingList, in, baseURI, syntax);
    }

    public static UpdateRequest read(InputStream input) {
        return UpdateFactory.read(input, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input) {
        return UpdateFactory.read(usingList, input, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(InputStream input, Syntax syntax) {
        return UpdateFactory.read(input, null, syntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input, Syntax syntax) {
        return UpdateFactory.read(usingList, input, null, syntax);
    }

    public static UpdateRequest read(InputStream input, String baseURI) {
        return UpdateFactory.read(input, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input, String baseURI) {
        return UpdateFactory.read(usingList, input, baseURI, Syntax.defaultUpdateSyntax);
    }

    public static UpdateRequest read(InputStream input, String baseURI, Syntax syntax) {
        return UpdateFactory.read(null, input, baseURI, syntax);
    }

    public static UpdateRequest read(UsingList usingList, InputStream input, String baseURI, Syntax syntax) {
        UpdateRequest request = new UpdateRequest();
        UpdateFactory.make(request, usingList, input, baseURI, syntax);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void make(UpdateRequest request, UsingList usingList, InputStream input, String baseURI, Syntax syntax) {
        UpdateParser parser = UpdateFactory.setupParser(request, baseURI, syntax);
        UsingUpdateSink sink = new UsingUpdateSink(new UpdateRequestSink(request), usingList);
        try {
            parser.parse((UpdateSink)sink, input);
        }
        finally {
            sink.close();
        }
    }
}

