/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Closeable;

public class ResultSetStream
implements ResultSet {
    private Iterator<Binding> queryExecutionIter;
    private List<String> resultVars;
    private QuerySolution currentQuerySolution;
    private int rowNumber;
    private Model model;

    public ResultSetStream(List<String> resultVars, Model m, Iterator<Binding> iter) {
        this.queryExecutionIter = iter;
        this.resultVars = resultVars;
        this.currentQuerySolution = null;
        this.rowNumber = 0;
        this.model = m;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    @Override
    public boolean hasNext() {
        if (this.queryExecutionIter == null) {
            return false;
        }
        boolean r = this.queryExecutionIter.hasNext();
        if (!r) {
            this.close();
        }
        return r;
    }

    @Override
    public Binding nextBinding() {
        if (this.queryExecutionIter == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        try {
            Binding binding = this.queryExecutionIter.next();
            if (binding != null) {
                ++this.rowNumber;
            }
            return binding;
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    private void close() {
        if (this.queryExecutionIter instanceof Closeable) {
            ((Closeable)((Object)this.queryExecutionIter)).close();
        }
    }

    @Override
    public QuerySolution nextSolution() {
        if (this.queryExecutionIter == null) {
            throw new NoSuchElementException(this.getClass() + ".next");
        }
        Binding binding = this.nextBinding();
        this.currentQuerySolution = new ResultBinding(this.model, binding);
        return this.currentQuerySolution;
    }

    @Override
    public QuerySolution next() {
        return this.nextSolution();
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public List<String> getResultVars() {
        return this.resultVars;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }
}

