/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io.parserjavacc;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.io.JSONHandler;

public class JSONPrinter
implements JSONHandler {
    IndentedWriter out;

    @Override
    public void startParse(long currLine, long currCol) {
        this.out = new IndentedWriter(System.out, true);
    }

    @Override
    public void finishParse(long currLine, long currCol) {
        this.out.flush();
    }

    @Override
    public void startObject(long currLine, long currCol) {
        this.out.println(">>Object");
        this.out.incIndent();
    }

    @Override
    public void finishObject(long currLine, long currCol) {
        this.out.decIndent();
        this.out.println("<<Object");
    }

    @Override
    public void startPair(long currLine, long currCol) {
        this.out.println(">Pair");
        this.out.incIndent();
    }

    @Override
    public void keyPair(long currLine, long currCol) {
    }

    @Override
    public void finishPair(long currLine, long currCol) {
        this.out.decIndent();
        this.out.println("<Pair");
    }

    @Override
    public void startArray(long currLine, long currCol) {
        this.out.println(">>Array");
        this.out.incIndent();
    }

    @Override
    public void element(long currLine, long currCol) {
    }

    @Override
    public void finishArray(long currLine, long currCol) {
        this.out.decIndent();
        this.out.println("<<Array");
    }

    @Override
    public void valueBoolean(boolean b, long currLine, long currCol) {
        this.out.println("Boolean: " + b);
    }

    @Override
    public void valueDecimal(String image, long currLine, long currCol) {
        this.out.println("Decimal: " + image);
    }

    @Override
    public void valueDouble(String image, long currLine, long currCol) {
        this.out.println("Double: " + image);
    }

    @Override
    public void valueInteger(String image, long currLine, long currCol) {
        this.out.println("Integer: " + image);
    }

    @Override
    public void valueNull(long currLine, long currCol) {
        this.out.println("Null");
    }

    @Override
    public void valueString(String image, long currLine, long currCol) {
        this.out.println("String: " + image);
    }
}

