/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrCache;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFileAccess;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFreeChain;
import com.hp.hpl.jena.tdb.base.block.BlockMgrTracker;
import com.hp.hpl.jena.tdb.base.file.BlockAccess;
import com.hp.hpl.jena.tdb.base.file.BlockAccessDirect;
import com.hp.hpl.jena.tdb.base.file.BlockAccessMapped;
import com.hp.hpl.jena.tdb.base.file.BlockAccessMem;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.apache.jena.atlas.lib.FileOps;

public class BlockMgrFactory {
    public static boolean AddTracker = false;

    public static BlockMgr tracker(BlockMgr blockMgr) {
        if (blockMgr instanceof BlockMgrTracker) {
            return blockMgr;
        }
        return BlockMgrTracker.track(blockMgr);
    }

    private static BlockMgr track(BlockMgr blockMgr) {
        if (!AddTracker) {
            return blockMgr;
        }
        return BlockMgrFactory.tracker(blockMgr);
    }

    public static BlockMgr create(FileSet fileSet, String ext, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        if (fileSet.isMem()) {
            return BlockMgrFactory.createMem(fileSet.filename(ext), blockSize);
        }
        return BlockMgrFactory.createFile(fileSet.filename(ext), blockSize, readBlockCacheSize, writeBlockCacheSize);
    }

    public static BlockMgr createMem(String indexName, int blockSize) {
        BlockAccessMem file = new BlockAccessMem(indexName, blockSize);
        BlockMgr blockMgr = new BlockMgrFileAccess(file, blockSize);
        blockMgr = new BlockMgrFreeChain(blockMgr);
        return BlockMgrFactory.track(blockMgr);
    }

    public static BlockMgr createFile(String filename, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        switch (SystemTDB.fileMode()) {
            case mapped: {
                return BlockMgrFactory.createMMapFile(filename, blockSize);
            }
            case direct: {
                return BlockMgrFactory.createStdFile(filename, blockSize, readBlockCacheSize, writeBlockCacheSize);
            }
        }
        throw new TDBException("Unknown file mode: " + (Object)((Object)SystemTDB.fileMode()));
    }

    public static BlockMgr createMMapFile(String filename, int blockSize) {
        BlockAccessMapped file = new BlockAccessMapped(filename, blockSize);
        BlockMgr blockMgr = BlockMgrFactory.wrapFileAccess(file, blockSize);
        return BlockMgrFactory.track(blockMgr);
    }

    public static BlockMgr createStdFile(String filename, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        BlockAccessDirect file = new BlockAccessDirect(filename, blockSize);
        BlockMgr blockMgr = BlockMgrFactory.wrapFileAccess(file, blockSize);
        String fn = FileOps.basename((String)filename);
        blockMgr = BlockMgrCache.create(fn, readBlockCacheSize, writeBlockCacheSize, blockMgr);
        return BlockMgrFactory.track(blockMgr);
    }

    public static BlockMgr createStdFileNoCache(String filename, int blockSize) {
        BlockAccessDirect blockAccess = new BlockAccessDirect(filename, blockSize);
        BlockMgrFileAccess blockMgr = new BlockMgrFileAccess(blockAccess, blockSize);
        return blockMgr;
    }

    private static BlockMgr wrapFileAccess(BlockAccess blockAccess, int blockSize) {
        BlockMgr blockMgr = new BlockMgrFileAccess(blockAccess, blockSize);
        blockMgr = new BlockMgrFreeChain(blockMgr);
        return blockMgr;
    }
}

