/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.dataquery;

import edu.ucsb.nceas.utilities.OrderedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.ANDRelation;
import org.ecoinformatics.datamanager.database.Condition;
import org.ecoinformatics.datamanager.database.ConditionInterface;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.ecoinformatics.datamanager.database.Join;
import org.ecoinformatics.datamanager.database.LogicalRelation;
import org.ecoinformatics.datamanager.database.ORRelation;
import org.ecoinformatics.datamanager.database.Query;
import org.ecoinformatics.datamanager.database.SelectionItem;
import org.ecoinformatics.datamanager.database.StaticSelectionItem;
import org.ecoinformatics.datamanager.database.SubQueryClause;
import org.ecoinformatics.datamanager.database.TableItem;
import org.ecoinformatics.datamanager.database.Union;
import org.ecoinformatics.datamanager.database.WhereClause;
import org.ecoinformatics.datamanager.dataquery.BasicNode;
import org.ecoinformatics.datamanager.download.DocumentHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.download.document.DocumentDataPackageHandler;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DataquerySpecification
extends DefaultHandler {
    private DatabaseConnectionPoolInterface connectionPool;
    private EcogridEndPointInterface ecogridEndPoint;
    private StringBuffer xml = new StringBuffer();
    private StringBuffer textBuffer = new StringBuffer();
    private String parserName = null;
    private Stack elementStack = new Stack();
    private Stack datapackageStack = new Stack();
    private Stack queryStack = new Stack();
    private Stack entityStack = new Stack();
    private Vector attributes = new Vector();
    private Stack conditionStack = new Stack();
    private Stack logicalStack = new Stack();
    private Stack subQueryStack = new Stack();
    private LogicalRelation currentLogical = null;
    private LogicalRelation currentSubQueryLogical = null;
    private DocumentDataPackageHandler ddpHandler = null;
    private DataPackage metadataPackage = null;
    private boolean inCondition = false;
    private static Log log = LogFactory.getLog(DataquerySpecification.class);
    private Map fetchedDatapackages = new HashMap();
    private Map metadataDatapackages = new HashMap();
    private List queryList = new ArrayList();
    private Union union = null;

    public DataquerySpecification(Reader queryspec, String parserName, DatabaseConnectionPoolInterface connectionPool, EcogridEndPointInterface ecogridEndPoint) throws IOException {
        this.connectionPool = connectionPool;
        this.ecogridEndPoint = ecogridEndPoint;
        this.parserName = parserName;
        XMLReader parser = this.initializeParser();
        if (parser == null) {
            log.error((Object)"SAX parser not instantiated properly.");
        }
        try {
            parser.parse(new InputSource(queryspec));
        }
        catch (SAXException e) {
            log.error((Object)"error parsing data in DataquerySpecification.DataquerySpecification");
            log.error((Object)e.getMessage());
        }
    }

    public DataquerySpecification(String queryspec, String parserName, DatabaseConnectionPoolInterface connectionPool, EcogridEndPointInterface ecogridEndPoint) throws IOException {
        this(new StringReader(queryspec), parserName, connectionPool, ecogridEndPoint);
    }

    public Query getQuery() {
        return (Query)this.queryList.get(0);
    }

    public Union getUnion() {
        return this.union;
    }

    public DataPackage[] getDataPackages() {
        return this.datapackageStack.toArray(new DataPackage[0]);
    }

    private XMLReader initializeParser() {
        XMLReader parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader(this.parserName);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
        }
        catch (Exception e) {
            System.err.println("Error in QuerySpcecification.initializeParser " + e.toString());
        }
        return parser;
    }

    private void startQuery(BasicNode currentNode) {
        Query query = new Query();
        boolean distinct = Boolean.parseBoolean(currentNode.getAttribute("distinct"));
        query.setDistinct(distinct);
        this.queryStack.push(query);
    }

    private void startSubquery(BasicNode currentNode) {
        Query query = new Query();
        this.subQueryStack.push(query);
    }

    private void startDatapackage(BasicNode currentNode) {
        String docId = currentNode.getAttribute("id");
        DataPackage datapackage = (DataPackage)this.fetchedDatapackages.get(docId);
        if (datapackage == null) {
            DocumentHandler dh = new DocumentHandler();
            dh.setDocId(docId);
            dh.setEcogridEndPointInterface(this.ecogridEndPoint);
            InputStream metadataInputStream = null;
            try {
                metadataInputStream = dh.downloadDocument();
            }
            catch (Exception e1) {
                log.error((Object)("could not download document: " + docId));
                e1.printStackTrace();
            }
            try {
                datapackage = DataManager.getInstance(this.connectionPool, this.connectionPool.getDBAdapterName()).parseMetadata(metadataInputStream);
            }
            catch (Exception e) {
                log.error((Object)("could not parse metadata given by docid: " + docId));
            }
            try {
                DataManager.getInstance(this.connectionPool, this.connectionPool.getDBAdapterName()).loadDataToDB(datapackage, this.ecogridEndPoint);
            }
            catch (Exception e) {
                log.error((Object)("could not load data given by docid: " + docId));
            }
            this.fetchedDatapackages.put(docId, datapackage);
        }
        this.datapackageStack.push(datapackage);
    }

    private void startEntity(BasicNode currentNode) {
        DataPackage datapackage = (DataPackage)this.datapackageStack.peek();
        Entity entity = null;
        String idAttribute = currentNode.getAttribute("id");
        String indexAttribute = currentNode.getAttribute("index");
        String nameAttribute = currentNode.getAttribute("name");
        if (idAttribute != null) {
            this.ddpHandler = new DocumentDataPackageHandler(this.connectionPool);
            this.ddpHandler.setDocId(idAttribute);
            this.ddpHandler.setEcogridEndPointInterface(this.ecogridEndPoint);
            this.ddpHandler.setAttributeMap((Map)new OrderedMap());
            if (this.inCondition) {
                this.metadataPackage = new DataPackage(idAttribute);
            }
        } else if (indexAttribute != null) {
            int index = Integer.parseInt(indexAttribute);
            entity = datapackage.getEntityList()[index];
        } else if (nameAttribute != null) {
            entity = datapackage.getEntity(nameAttribute);
        }
        this.entityStack.push(entity);
    }

    private void startAttribute(BasicNode currentNode) {
        this.attributes.add(currentNode);
    }

    private void startCondition(BasicNode currentNode) {
        this.inCondition = true;
        ConditionInterface condition = null;
        condition = currentNode.getAttribute("type").equals("subquery") ? new SubQueryClause(null, null, null, null) : (currentNode.getAttribute("type").equals("join") ? new Join(null, null, null, null) : new Condition(null, null, null, null));
        this.conditionStack.push(condition);
    }

    private void startAnd(BasicNode currentNode) {
        ANDRelation and = new ANDRelation();
        if (this.subQueryStack.isEmpty()) {
            if (this.currentLogical != null) {
                this.currentLogical.addANDRelation(and);
            }
            this.currentLogical = and;
            this.logicalStack.push(this.currentLogical);
        } else {
            if (this.currentSubQueryLogical != null) {
                this.currentSubQueryLogical.addANDRelation(and);
            }
            this.currentSubQueryLogical = and;
            this.logicalStack.push(this.currentSubQueryLogical);
        }
    }

    private void startOr(BasicNode currentNode) {
        ORRelation or = new ORRelation();
        if (this.subQueryStack.isEmpty()) {
            if (this.currentLogical != null) {
                this.currentLogical.addORRelation(or);
            }
            this.currentLogical = or;
            this.logicalStack.push(this.currentLogical);
        } else {
            if (this.currentSubQueryLogical != null) {
                this.currentSubQueryLogical.addORRelation(or);
            }
            this.currentSubQueryLogical = or;
            this.logicalStack.push(this.currentSubQueryLogical);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        log.debug((Object)("<" + localName + ">"));
        BasicNode currentNode = new BasicNode(localName);
        this.xml.append("<");
        this.xml.append(localName);
        if (atts != null) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                currentNode.setAttribute(atts.getLocalName(i), atts.getValue(i));
                this.xml.append(" ");
                this.xml.append(atts.getLocalName(i));
                this.xml.append("=\"");
                this.xml.append(atts.getValue(i));
                this.xml.append("\"");
            }
        }
        this.xml.append(">");
        this.elementStack.push(currentNode);
        if (currentNode.getTagName().equals("query")) {
            this.startQuery(currentNode);
        }
        if (currentNode.getTagName().equals("subquery")) {
            this.startSubquery(currentNode);
        }
        if (currentNode.getTagName().equals("datapackage")) {
            this.startDatapackage(currentNode);
        }
        if (currentNode.getTagName().equals("entity")) {
            this.startEntity(currentNode);
        }
        if (currentNode.getTagName().equals("attribute")) {
            this.startAttribute(currentNode);
        }
        if (currentNode.getTagName().equals("condition")) {
            this.startCondition(currentNode);
        }
        if (currentNode.getTagName().equals("and")) {
            this.startAnd(currentNode);
        }
        if (currentNode.getTagName().equals("or")) {
            this.startOr(currentNode);
        }
    }

    private void endUnion(BasicNode leaving) {
        this.union = new Union();
        for (int i = 0; i < this.queryList.size(); ++i) {
            this.union.addQuery((Query)this.queryList.get(i));
        }
        String orderAttr = leaving.getAttribute("order");
        if (orderAttr != null) {
            boolean orderQueryList = Boolean.parseBoolean(orderAttr);
            this.union.setOrderQueryList(orderQueryList);
        }
    }

    private void endQuery(BasicNode leaving) {
        Query query = (Query)this.queryStack.pop();
        this.queryList.add(query);
    }

    private void endSubquery(BasicNode leaving) {
        this.subQueryStack.pop();
    }

    private void constructEntity() {
        if (this.ddpHandler != null) {
            try {
                if (!this.inCondition) {
                    this.metadataPackage = this.ddpHandler.loadDataToDB();
                    this.metadataDatapackages.put(this.metadataPackage.getPackageId(), this.metadataPackage);
                }
                this.metadataPackage = (DataPackage)this.metadataDatapackages.get(this.metadataPackage.getPackageId());
                this.entityStack.pop();
                this.entityStack.push(this.metadataPackage.getEntityList()[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Entity entity = (Entity)this.entityStack.peek();
        for (int i = 0; i < this.attributes.size(); ++i) {
            BasicNode leaving = (BasicNode)this.attributes.get(i);
            Attribute attribute = null;
            String indexAttribute = leaving.getAttribute("index");
            if (indexAttribute != null) {
                int index = Integer.parseInt(indexAttribute);
                attribute = entity.getAttributes()[index];
            } else {
                String nameAttribute = leaving.getAttribute("name");
                attribute = entity.getAttributeList().getAttribute(nameAttribute);
            }
            if (!this.conditionStack.isEmpty()) {
                ConditionInterface condition = (ConditionInterface)this.conditionStack.pop();
                if (condition instanceof Condition) {
                    condition = new Condition(entity, attribute, null, null);
                } else if (condition instanceof SubQueryClause) {
                    Query subQuery = null;
                    subQuery = this.subQueryStack.isEmpty() ? new Query() : (Query)this.subQueryStack.peek();
                    SelectionItem selection = new SelectionItem(entity, attribute);
                    subQuery.addSelectionItem(selection);
                    String operator = ((SubQueryClause)condition).getOperator();
                    condition = new SubQueryClause(entity, attribute, operator, subQuery);
                } else if (condition instanceof Join) {
                    if (!((Join)condition).isLeftSet()) {
                        ((Join)condition).setLeft(entity, attribute);
                    } else if (!((Join)condition).isRightSet()) {
                        ((Join)condition).setRight(entity, attribute);
                    }
                }
                this.conditionStack.push(condition);
                continue;
            }
            Query query = (Query)this.queryStack.peek();
            SelectionItem selection = new SelectionItem(entity, attribute);
            query.addSelectionItem(selection);
        }
        this.attributes.clear();
    }

    private void endEntity(BasicNode leaving) {
        Entity entity;
        this.constructEntity();
        if (this.conditionStack.isEmpty()) {
            entity = (Entity)this.entityStack.pop();
            Query query = (Query)this.queryStack.peek();
            query.addTableItem(new TableItem(entity));
        }
        if (!this.subQueryStack.isEmpty()) {
            entity = (Entity)this.entityStack.pop();
            Query subQuery = (Query)this.subQueryStack.peek();
            subQuery.addTableItem(new TableItem(entity));
        }
        if (this.ddpHandler != null) {
            this.ddpHandler = null;
        }
    }

    private void endPathexpr(BasicNode leaving) {
        String labelAttribute = leaving.getAttribute("label");
        this.ddpHandler.getAttributeMap().put(labelAttribute, this.textBuffer.toString().trim());
    }

    private void endAttribute(BasicNode leaving) {
    }

    private void endOperator(BasicNode leaving) {
        String operator = this.textBuffer.toString().trim();
        ConditionInterface condition = (ConditionInterface)this.conditionStack.peek();
        if (condition instanceof Condition) {
            ((Condition)condition).setOperator(operator);
        }
        if (condition instanceof SubQueryClause) {
            ((SubQueryClause)condition).setOperator(operator);
        }
    }

    private void endValue(BasicNode leaving) {
        Object value = this.textBuffer.toString().trim();
        try {
            value = Integer.parseInt((String)value);
        }
        catch (Exception e) {
            try {
                value = Double.parseDouble((String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ConditionInterface condition = (ConditionInterface)this.conditionStack.peek();
        if (condition instanceof Condition) {
            ((Condition)condition).setValue(value);
        }
    }

    private void endWhere(BasicNode leaving) {
        if (!this.subQueryStack.isEmpty()) {
            WhereClause where = new WhereClause((ConditionInterface)null);
            if (this.currentSubQueryLogical != null) {
                if (this.currentSubQueryLogical instanceof ANDRelation) {
                    where = new WhereClause((ANDRelation)this.currentSubQueryLogical);
                }
            } else if (!this.conditionStack.isEmpty()) {
                ConditionInterface condition = (ConditionInterface)this.conditionStack.pop();
                where = new WhereClause(condition);
            }
            Query subQuery = (Query)this.subQueryStack.peek();
            subQuery.setWhereClause(where);
        } else {
            WhereClause where = new WhereClause((ConditionInterface)null);
            if (!this.conditionStack.isEmpty()) {
                ConditionInterface condition = (ConditionInterface)this.conditionStack.pop();
                where = new WhereClause(condition);
            } else if (this.currentLogical != null) {
                where = this.currentLogical instanceof ANDRelation ? new WhereClause((ANDRelation)this.currentLogical) : new WhereClause((ORRelation)this.currentLogical);
            }
            Query query = (Query)this.queryStack.peek();
            query.setWhereClause(where);
        }
    }

    private void endCondition(BasicNode leaving) {
        this.inCondition = false;
        if (!this.subQueryStack.isEmpty()) {
            if (this.currentSubQueryLogical != null) {
                this.currentSubQueryLogical.addCondtionInterface((ConditionInterface)this.conditionStack.pop());
            }
        } else if (this.currentLogical != null) {
            this.currentLogical.addCondtionInterface((ConditionInterface)this.conditionStack.pop());
        }
    }

    private void endAnd(BasicNode leaving) {
        if (!this.subQueryStack.isEmpty()) {
            this.currentSubQueryLogical = (LogicalRelation)this.logicalStack.pop();
        } else {
            this.currentLogical = (LogicalRelation)this.logicalStack.pop();
        }
    }

    private void endOr(BasicNode leaving) {
        if (!this.subQueryStack.isEmpty()) {
            this.currentSubQueryLogical = (LogicalRelation)this.logicalStack.pop();
        } else {
            this.currentLogical = (LogicalRelation)this.logicalStack.pop();
        }
    }

    private void endStaticItem(BasicNode leaving) {
        String name = leaving.getAttribute("name");
        String value = leaving.getAttribute("value");
        StaticSelectionItem selection = new StaticSelectionItem(name, value);
        Query query = (Query)this.queryStack.peek();
        query.addSelectionItem(selection);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        BasicNode leaving = (BasicNode)this.elementStack.pop();
        if (leaving.getTagName().equals("union")) {
            this.endUnion(leaving);
        }
        if (leaving.getTagName().equals("query")) {
            this.endQuery(leaving);
        }
        if (leaving.getTagName().equals("subquery")) {
            this.endSubquery(leaving);
        }
        if (leaving.getTagName().equals("entity")) {
            this.endEntity(leaving);
        }
        if (leaving.getTagName().equals("pathexpr")) {
            this.endPathexpr(leaving);
        }
        if (leaving.getTagName().equals("attribute")) {
            this.endAttribute(leaving);
        }
        if (leaving.getTagName().equals("operator")) {
            this.endOperator(leaving);
        }
        if (leaving.getTagName().equals("value")) {
            this.endValue(leaving);
        }
        if (leaving.getTagName().equals("where")) {
            this.endWhere(leaving);
        }
        if (leaving.getTagName().equals("condition")) {
            this.endCondition(leaving);
        }
        if (leaving.getTagName().equals("and")) {
            this.endAnd(leaving);
        }
        if (leaving.getTagName().equals("or")) {
            this.endOr(leaving);
        }
        if (leaving.getTagName().equals("staticItem")) {
            this.endStaticItem(leaving);
        }
        String normalizedXML = this.textBuffer.toString().trim();
        this.xml.append(normalizedXML);
        this.xml.append("</");
        this.xml.append(localName);
        this.xml.append(">");
        this.textBuffer = new StringBuffer();
        log.debug((Object)("</" + localName + ">"));
    }

    public String getXML() {
        return this.xml.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length);
        this.textBuffer.append(text);
        text = text.trim();
        if (text != null && text.length() > 0) {
            log.debug((Object)text);
        }
    }

    public String toString() {
        return this.xml.toString();
    }
}

