/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Stopwatch;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$LoadingValueReference$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Futures;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.SettableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Uninterruptibles;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class LocalCache$LoadingValueReference
implements LocalCache$ValueReference {
    volatile LocalCache$ValueReference oldValue;
    final SettableFuture futureValue = SettableFuture.create();
    final Stopwatch stopwatch = Stopwatch.createUnstarted();

    public LocalCache$LoadingValueReference() {
        this(LocalCache.unset());
    }

    public LocalCache$LoadingValueReference(LocalCache$ValueReference localCache$ValueReference) {
        this.oldValue = localCache$ValueReference;
    }

    @Override
    public boolean isLoading() {
        return true;
    }

    @Override
    public boolean isActive() {
        return this.oldValue.isActive();
    }

    @Override
    public int getWeight() {
        return this.oldValue.getWeight();
    }

    public boolean set(@Nullable Object object) {
        return this.futureValue.set(object);
    }

    public boolean setException(Throwable throwable) {
        return this.futureValue.setException(throwable);
    }

    private ListenableFuture fullyFailedFuture(Throwable throwable) {
        return Futures.immediateFailedFuture(throwable);
    }

    @Override
    public void notifyNewValue(@Nullable Object object) {
        if (object != null) {
            this.set(object);
        } else {
            this.oldValue = LocalCache.unset();
        }
    }

    public ListenableFuture loadFuture(Object object, CacheLoader cacheLoader) {
        this.stopwatch.start();
        Object object2 = this.oldValue.get();
        try {
            if (object2 == null) {
                Object object3 = cacheLoader.load(object);
                return this.set(object3) ? this.futureValue : Futures.immediateFuture(object3);
            }
            ListenableFuture listenableFuture = cacheLoader.reload(object, object2);
            if (listenableFuture == null) {
                return Futures.immediateFuture(null);
            }
            return Futures.transform(listenableFuture, new LocalCache$LoadingValueReference$1(this));
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return this.setException(throwable) ? this.futureValue : this.fullyFailedFuture(throwable);
        }
    }

    public long elapsedNanos() {
        return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
    }

    @Override
    public Object waitForValue() {
        return Uninterruptibles.getUninterruptibly(this.futureValue);
    }

    @Override
    public Object get() {
        return this.oldValue.get();
    }

    public LocalCache$ValueReference getOldValue() {
        return this.oldValue;
    }

    @Override
    public LocalCache$ReferenceEntry getEntry() {
        return null;
    }

    @Override
    public LocalCache$ValueReference copyFor(ReferenceQueue referenceQueue, @Nullable Object object, LocalCache$ReferenceEntry localCache$ReferenceEntry) {
        return this;
    }
}

