/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import org.apache.solr.schema.IntValueFieldType;
import org.apache.solr.schema.TrieField;

public class TrieIntField
extends TrieField
implements IntValueFieldType {
    public TrieIntField() {
        this.type = TrieField.TrieTypes.INTEGER;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
        }
        catch (NumberFormatException e) {
            Float v = Float.valueOf(Float.parseFloat((String)val));
            return v.intValue();
        }
        return super.toNativeType(val);
    }
}

