/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.mockrandom.MockRandomPostingsFormat;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.RandomCodec;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.SimpleMergedSegmentWarmer;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.RamUsageTester;
import org.apache.lucene.util.Rethrow;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.Version;

abstract class BaseIndexFileFormatTestCase
extends LuceneTestCase {
    private static final Set<Class<?>> EXCLUDED_CLASSES = Collections.newSetFromMap(new IdentityHashMap());
    private Codec savedCodec;

    BaseIndexFileFormatTestCase() {
    }

    protected abstract Codec getCodec();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.savedCodec = Codec.getDefault();
        Codec.setDefault((Codec)this.getCodec());
    }

    @Override
    public void tearDown() throws Exception {
        Codec.setDefault((Codec)this.savedCodec);
        super.tearDown();
    }

    protected abstract void addRandomFields(Document var1);

    private Map<String, Long> bytesUsedByExtension(Directory d) throws IOException {
        HashMap<String, Long> bytesUsedByExtension = new HashMap<String, Long>();
        for (String file : d.listAll()) {
            if (!IndexFileNames.CODEC_FILE_PATTERN.matcher(file).matches()) continue;
            String ext = IndexFileNames.getExtension((String)file);
            long previousLength = bytesUsedByExtension.containsKey(ext) ? (Long)bytesUsedByExtension.get(ext) : 0L;
            bytesUsedByExtension.put(ext, previousLength + d.fileLength(file));
        }
        bytesUsedByExtension.keySet().removeAll(this.excludedExtensionsFromByteCounts());
        return bytesUsedByExtension;
    }

    protected Collection<String> excludedExtensionsFromByteCounts() {
        return new HashSet<String>(Arrays.asList("si", "lock"));
    }

    public void testMergeStability() throws Exception {
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCase.newDirectory();
        if (dir instanceof MockDirectoryWrapper) {
            ((MockDirectoryWrapper)dir).setEnableVirusScanner(false);
        }
        TieredMergePolicy mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        IndexWriterConfig cfg = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        IndexWriter w = new IndexWriter((Directory)dir, cfg);
        int numDocs = BaseIndexFileFormatTestCase.atLeast(500);
        for (int i = 0; i < numDocs; ++i) {
            Document d = new Document();
            this.addRandomFields(d);
            w.addDocument((Iterable)d);
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        BaseDirectoryWrapper dir2 = BaseIndexFileFormatTestCase.newDirectory();
        if (dir2 instanceof MockDirectoryWrapper) {
            ((MockDirectoryWrapper)dir2).setEnableVirusScanner(false);
        }
        mp = BaseIndexFileFormatTestCase.newTieredMergePolicy();
        mp.setNoCFSRatio(0.0);
        cfg = new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())).setUseCompoundFile(false).setMergePolicy((MergePolicy)mp);
        w = new IndexWriter((Directory)dir2, cfg);
        TestUtil.addIndexesSlowly(w, reader);
        w.commit();
        w.close();
        BaseIndexFileFormatTestCase.assertEquals(this.bytesUsedByExtension((Directory)dir), this.bytesUsedByExtension((Directory)dir2));
        reader.close();
        dir.close();
        dir2.close();
    }

    @LuceneTestCase.Slow
    public void testRamBytesUsed() throws IOException {
        if (Codec.getDefault() instanceof RandomCodec) {
            HashSet<String> avoidCodecs = new HashSet<String>(((RandomCodec)Codec.getDefault()).avoidCodecs);
            avoidCodecs.add(new MockRandomPostingsFormat().getName());
            Codec.setDefault((Codec)new RandomCodec(BaseIndexFileFormatTestCase.random(), avoidCodecs));
        }
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCase.newDirectory();
        IndexWriterConfig cfg = BaseIndexFileFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BaseIndexFileFormatTestCase.random()));
        IndexWriter w = new IndexWriter((Directory)dir, cfg);
        int numDocs = BaseIndexFileFormatTestCase.atLeast(10000);
        SegmentReader reader1 = null;
        for (int i = 0; i < numDocs; ++i) {
            Document d = new Document();
            this.addRandomFields(d);
            w.addDocument((Iterable)d);
            if (i != 100) continue;
            w.forceMerge(1);
            w.commit();
            reader1 = BaseIndexFileFormatTestCase.getOnlySegmentReader(DirectoryReader.open((Directory)dir));
        }
        w.forceMerge(1);
        w.commit();
        w.close();
        SegmentReader reader2 = BaseIndexFileFormatTestCase.getOnlySegmentReader(DirectoryReader.open((Directory)dir));
        for (LeafReader reader : Arrays.asList(reader1, reader2)) {
            new SimpleMergedSegmentWarmer(InfoStream.NO_OUTPUT).warm(reader);
        }
        long actualBytes = RamUsageTester.sizeOf(reader2, new Accumulator(reader2)) - RamUsageTester.sizeOf(reader1, new Accumulator(reader1));
        long expectedBytes = reader2.ramBytesUsed() - reader1.ramBytesUsed();
        long absoluteError = actualBytes - expectedBytes;
        double relativeError = (double)absoluteError / (double)actualBytes;
        String message = "Actual RAM usage " + actualBytes + ", but got " + expectedBytes + ", " + 100.0 * relativeError + "% error";
        BaseIndexFileFormatTestCase.assertTrue((String)message, (Math.abs(relativeError) < 0.2 || Math.abs(absoluteError) < 1000L ? 1 : 0) != 0);
        reader1.close();
        reader2.close();
        dir.close();
    }

    public void testMultiClose() throws IOException {
        BaseDirectoryWrapper oneDocIndex = BaseIndexFileFormatTestCase.newDirectory();
        IndexWriter iw = new IndexWriter((Directory)oneDocIndex, new IndexWriterConfig((Analyzer)new MockAnalyzer(BaseIndexFileFormatTestCase.random())));
        Document oneDoc = new Document();
        FieldType customType = new FieldType(TextField.TYPE_STORED);
        customType.setStoreTermVectors(true);
        org.apache.lucene.document.Field customField = new org.apache.lucene.document.Field("field", "contents", customType);
        oneDoc.add((IndexableField)customField);
        oneDoc.add((IndexableField)new NumericDocValuesField("field", 5L));
        iw.addDocument((Iterable)oneDoc);
        SegmentReader oneDocReader = BaseIndexFileFormatTestCase.getOnlySegmentReader(DirectoryReader.open((IndexWriter)iw, (boolean)true));
        iw.close();
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCase.newFSDirectory(BaseIndexFileFormatTestCase.createTempDir("justSoYouGetSomeChannelErrors"));
        Codec codec = this.getCodec();
        SegmentInfo segmentInfo = new SegmentInfo((Directory)dir, Version.LATEST, "_0", 1, false, codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap());
        FieldInfo proto = oneDocReader.getFieldInfos().fieldInfo("field");
        FieldInfo field = new FieldInfo(proto.name, proto.number, proto.hasVectors(), proto.omitsNorms(), proto.hasPayloads(), proto.getIndexOptions(), proto.getDocValuesType(), proto.getDocValuesGen(), new HashMap());
        FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{field});
        SegmentWriteState writeState = new SegmentWriteState(null, (Directory)dir, segmentInfo, fieldInfos, null, new IOContext(new FlushInfo(1, 20L)));
        SegmentReadState readState = new SegmentReadState((Directory)dir, segmentInfo, fieldInfos, IOContext.READ);
        try (FieldsConsumer consumer = codec.postingsFormat().fieldsConsumer(writeState);){
            consumer.write(oneDocReader.fields());
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        var16_16 = null;
        try (FieldsProducer producer = codec.postingsFormat().fieldsProducer(readState);){
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        consumer = codec.docValuesFormat().fieldsConsumer(writeState);
        var16_16 = null;
        try {
            consumer.addNumericField(field, Collections.singleton(5));
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        finally {
            if (consumer != null) {
                if (var16_16 != null) {
                    try {
                        consumer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    consumer.close();
                }
            }
        }
        producer = codec.docValuesFormat().fieldsProducer(readState);
        var16_16 = null;
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        finally {
            if (producer != null) {
                if (var16_16 != null) {
                    try {
                        producer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    producer.close();
                }
            }
        }
        consumer = codec.normsFormat().normsConsumer(writeState);
        var16_16 = null;
        try {
            consumer.addNormsField(field, Collections.singleton(5));
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        finally {
            if (consumer != null) {
                if (var16_16 != null) {
                    try {
                        consumer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    consumer.close();
                }
            }
        }
        producer = codec.normsFormat().normsProducer(readState);
        var16_16 = null;
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        finally {
            if (producer != null) {
                if (var16_16 != null) {
                    try {
                        producer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    producer.close();
                }
            }
        }
        consumer = codec.termVectorsFormat().vectorsWriter((Directory)dir, segmentInfo, writeState.context);
        var16_16 = null;
        try {
            consumer.startDocument(1);
            consumer.startField(field, 1, false, false, false);
            consumer.startTerm(new BytesRef((CharSequence)"testing"), 2);
            consumer.finishTerm();
            consumer.finishField();
            consumer.finishDocument();
            consumer.finish(fieldInfos, 1);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        finally {
            if (consumer != null) {
                if (var16_16 != null) {
                    try {
                        consumer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    consumer.close();
                }
            }
        }
        producer = codec.termVectorsFormat().vectorsReader((Directory)dir, segmentInfo, fieldInfos, readState.context);
        var16_16 = null;
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        finally {
            if (producer != null) {
                if (var16_16 != null) {
                    try {
                        producer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    producer.close();
                }
            }
        }
        consumer = codec.storedFieldsFormat().fieldsWriter((Directory)dir, segmentInfo, writeState.context);
        var16_16 = null;
        try {
            consumer.startDocument();
            consumer.writeField(field, (IndexableField)customField);
            consumer.finishDocument();
            consumer.finish(fieldInfos, 1);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        catch (Throwable x2) {
            var16_16 = x2;
            throw x2;
        }
        finally {
            if (consumer != null) {
                if (var16_16 != null) {
                    try {
                        consumer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    consumer.close();
                }
            }
        }
        producer = codec.storedFieldsFormat().fieldsReader((Directory)dir, segmentInfo, fieldInfos, readState.context);
        var16_16 = null;
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        catch (Throwable throwable) {
            var16_16 = throwable;
            throw throwable;
        }
        finally {
            if (producer != null) {
                if (var16_16 != null) {
                    try {
                        producer.close();
                    }
                    catch (Throwable x2) {
                        var16_16.addSuppressed(x2);
                    }
                } else {
                    producer.close();
                }
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{oneDocReader, oneDocIndex, dir});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRandomExceptions() throws Exception {
        MockDirectoryWrapper dir = BaseIndexFileFormatTestCase.newMockDirectory();
        dir.setThrottling(MockDirectoryWrapper.Throttling.NEVER);
        dir.setUseSlowOpenClosers(false);
        dir.setPreventDoubleWrite(false);
        dir.setRandomIOExceptionRate(0.001);
        ByteArrayOutputStream exceptionLog = new ByteArrayOutputStream();
        PrintStream exceptionStream = new PrintStream((OutputStream)exceptionLog, true, "UTF-8");
        MockAnalyzer analyzer = new MockAnalyzer(BaseIndexFileFormatTestCase.random());
        IndexWriterConfig conf = BaseIndexFileFormatTestCase.newIndexWriterConfig(analyzer);
        conf.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        conf.setCodec(this.getCodec());
        int numDocs = BaseIndexFileFormatTestCase.atLeast(500);
        IndexWriter iw = new IndexWriter((Directory)dir, conf);
        try {
            boolean allowAlreadyClosed = false;
            for (int i = 0; i < numDocs; ++i) {
                dir.setRandomIOExceptionRateOnOpen(0.02);
                Document doc = new Document();
                doc.add((IndexableField)BaseIndexFileFormatTestCase.newStringField("id", Integer.toString(i), Field.Store.NO));
                this.addRandomFields(doc);
                try {
                    iw.addDocument((Iterable)doc);
                    iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(i))});
                }
                catch (AlreadyClosedException ace) {
                    dir.setRandomIOExceptionRateOnOpen(0.0);
                    BaseIndexFileFormatTestCase.assertTrue((boolean)iw.deleter.isClosed());
                    BaseIndexFileFormatTestCase.assertTrue((boolean)allowAlreadyClosed);
                    allowAlreadyClosed = false;
                    conf = BaseIndexFileFormatTestCase.newIndexWriterConfig(analyzer);
                    conf.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                    conf.setCodec(this.getCodec());
                    iw = new IndexWriter((Directory)dir, conf);
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("a random IOException")) {
                        exceptionStream.println("\nTEST: got expected fake exc:" + e.getMessage());
                        e.printStackTrace(exceptionStream);
                        allowAlreadyClosed = true;
                    }
                    Rethrow.rethrow(e);
                }
                if (BaseIndexFileFormatTestCase.random().nextInt(10) != 0) continue;
                try {
                    block20: {
                        block19: {
                            if (!BaseIndexFileFormatTestCase.random().nextBoolean()) break block19;
                            DirectoryReader ir = null;
                            try {
                                ir = DirectoryReader.open((IndexWriter)iw, (boolean)BaseIndexFileFormatTestCase.random().nextBoolean());
                                dir.setRandomIOExceptionRateOnOpen(0.0);
                                TestUtil.checkReader((IndexReader)ir);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{ir});
                                throw throwable;
                            }
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{ir});
                            break block20;
                        }
                        dir.setRandomIOExceptionRateOnOpen(0.0);
                        iw.commit();
                    }
                    if (!DirectoryReader.indexExists((Directory)dir)) continue;
                    TestUtil.checkIndex((Directory)dir);
                    continue;
                }
                catch (AlreadyClosedException ace) {
                    dir.setRandomIOExceptionRateOnOpen(0.0);
                    BaseIndexFileFormatTestCase.assertTrue((boolean)iw.deleter.isClosed());
                    BaseIndexFileFormatTestCase.assertTrue((boolean)allowAlreadyClosed);
                    allowAlreadyClosed = false;
                    conf = BaseIndexFileFormatTestCase.newIndexWriterConfig(analyzer);
                    conf.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                    conf.setCodec(this.getCodec());
                    iw = new IndexWriter((Directory)dir, conf);
                    continue;
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("a random IOException")) {
                        exceptionStream.println("\nTEST: got expected fake exc:" + e.getMessage());
                        e.printStackTrace(exceptionStream);
                        allowAlreadyClosed = true;
                        continue;
                    }
                    Rethrow.rethrow(e);
                }
            }
            try {
                dir.setRandomIOExceptionRateOnOpen(0.0);
                iw.close();
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().startsWith("a random IOException")) {
                    exceptionStream.println("\nTEST: got expected fake exc:" + e.getMessage());
                    e.printStackTrace(exceptionStream);
                    try {
                        iw.rollback();
                    }
                    catch (Throwable t) {}
                }
                Rethrow.rethrow(e);
            }
            dir.close();
        }
        catch (Throwable t) {
            System.out.println("Unexpected exception: dumping fake-exception-log:...");
            exceptionStream.flush();
            System.out.println(exceptionLog.toString("UTF-8"));
            System.out.flush();
            Rethrow.rethrow(t);
        }
        if (VERBOSE) {
            System.out.println("TEST PASSED: dumping fake-exception-log:...");
            System.out.println(exceptionLog.toString("UTF-8"));
        }
    }

    static {
        EXCLUDED_CLASSES.add(Directory.class);
        EXCLUDED_CLASSES.add(IndexInput.class);
        EXCLUDED_CLASSES.add(CloseableThreadLocal.class);
        EXCLUDED_CLASSES.add(ThreadLocal.class);
        EXCLUDED_CLASSES.add(IndexReader.class);
        EXCLUDED_CLASSES.add(IndexReaderContext.class);
        EXCLUDED_CLASSES.add(FieldInfos.class);
        EXCLUDED_CLASSES.add(SegmentInfo.class);
        EXCLUDED_CLASSES.add(SegmentCommitInfo.class);
        EXCLUDED_CLASSES.add(FieldInfo.class);
        EXCLUDED_CLASSES.add(String.class);
    }

    static class Accumulator
    extends RamUsageTester.Accumulator {
        private final Object root;

        Accumulator(Object root) {
            this.root = root;
        }

        @Override
        public long accumulateObject(Object o, long shallowSize, Map<Field, Object> fieldValues, Collection<Object> queue) {
            for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                if (!EXCLUDED_CLASSES.contains(clazz) || o == this.root) continue;
                return 0L;
            }
            if (o instanceof Collection) {
                Collection coll = (Collection)o;
                queue.addAll((Collection)o);
                return (long)coll.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                queue.addAll(map.keySet());
                queue.addAll(map.values());
                return 2L * (long)map.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            }
            long v = super.accumulateObject(o, shallowSize, fieldValues, queue);
            return v;
        }

        @Override
        public long accumulateArray(Object array, long shallowSize, List<Object> values, Collection<Object> queue) {
            long v = super.accumulateArray(array, shallowSize, values, queue);
            return v;
        }
    }
}

