/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import com.spatial4j.core.shape.Rectangle;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;

public abstract class BBoxSimilarityValueSource
extends ValueSource {
    private final ValueSource bboxValueSource;

    public BBoxSimilarityValueSource(ValueSource bboxValueSource) {
        this.bboxValueSource = bboxValueSource;
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.bboxValueSource.createWeight(context, searcher);
    }

    public String description() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.bboxValueSource.description() + "," + this.similarityDescription() + ")";
    }

    protected abstract String similarityDescription();

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues shapeValues = this.bboxValueSource.getValues(context, readerContext);
        return new DoubleDocValues(this){

            public double doubleVal(int doc) {
                Rectangle rect = (Rectangle)shapeValues.objectVal(doc);
                return rect == null ? 0.0 : BBoxSimilarityValueSource.this.score(rect, null);
            }

            public boolean exists(int doc) {
                return shapeValues.exists(doc);
            }

            public Explanation explain(int doc) {
                Rectangle rect = (Rectangle)shapeValues.objectVal(doc);
                if (rect == null) {
                    return Explanation.noMatch((String)"no rect", (Explanation[])new Explanation[0]);
                }
                AtomicReference<Explanation> explanation = new AtomicReference<Explanation>();
                BBoxSimilarityValueSource.this.score(rect, explanation);
                return explanation.get();
            }
        };
    }

    protected abstract double score(Rectangle var1, AtomicReference<Explanation> var2);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BBoxSimilarityValueSource that = (BBoxSimilarityValueSource)((Object)o);
        return this.bboxValueSource.equals((Object)that.bboxValueSource);
    }

    public int hashCode() {
        return this.bboxValueSource.hashCode();
    }
}

