/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import org.apache.mahout.common.DevURandomSeedGenerator;
import org.uncommons.maths.random.SecureRandomSeedGenerator;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public final class FastRandomSeedGenerator
implements SeedGenerator {
    private final SeedGenerator[] generators = new SeedGenerator[]{new DevURandomSeedGenerator(), new SecureRandomSeedGenerator()};

    public byte[] generateSeed(int length) throws SeedException {
        SeedException savedException = null;
        for (SeedGenerator generator : this.generators) {
            try {
                return generator.generateSeed(length);
            }
            catch (SeedException e) {
                if (savedException != null) {
                    savedException.initCause((Throwable)e);
                }
                savedException = e;
            }
        }
        if (savedException != null) {
            throw savedException;
        }
        throw new IllegalStateException("Couldn't generate seed, but didn't find an exception.  Can't happen.");
    }
}

