/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.request;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.solr.analytics.request.AnalyticsRequest;
import org.apache.solr.analytics.request.ExpressionRequest;
import org.apache.solr.analytics.request.FieldFacetRequest;
import org.apache.solr.analytics.request.QueryFacetRequest;
import org.apache.solr.analytics.request.RangeFacetRequest;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.schema.IndexSchema;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class AnalyticsContentHandler
implements ContentHandler {
    public final String ANALYTICS_REQUEST_ENVELOPE = "analyticsRequestEnvelope";
    public final String ANALYTICS_REQUEST = "analyticsRequest";
    public final String NAME = "name";
    public final String STATISTIC = "statistic";
    public final String EXPRESSION = "expression";
    public final String FIELD_FACET = "fieldFacet";
    public final String FIELD = "field";
    public final String SHOW_MISSING = "showMissing";
    public final String LIMIT = "limit";
    public final String MIN_COUNT = "minCount";
    public final String SORT_SPECIFICATION = "sortSpecification";
    public final String STAT_NAME = "statName";
    public final String DIRECTION = "direction";
    public final String RANGE_FACET = "rangeFacet";
    public final String START = "start";
    public final String END = "end";
    public final String GAP = "gap";
    public final String INCLUDE_BOUNDARY = "includeBoundary";
    public final String OTHER_RANGE = "otherRange";
    public final String HARD_END = "hardend";
    public final String QUERY_FACET = "queryFacet";
    public final String QUERY = "query";
    public static final int DEFAULT_FACET_LIMIT = -1;
    public static final boolean DEFAULT_FACET_HARDEND = false;
    public static final int DEFAULT_FACET_MINCOUNT = 0;
    public static final boolean DEFAULT_FACET_FIELD_SHOW_MISSING = false;
    boolean inEnvelope = false;
    boolean inRequest = false;
    boolean inStatistic = false;
    boolean inFieldFacet = false;
    boolean inSortSpecification = false;
    boolean inQueryFacet = false;
    boolean inRangeFacet = false;
    private final IndexSchema schema;
    String currentElementText;
    List<AnalyticsRequest> requests;
    AnalyticsRequest analyticsRequest;
    List<ExpressionRequest> expressionList;
    List<FieldFacetRequest> fieldFacetList;
    List<RangeFacetRequest> rangeFacetList;
    List<QueryFacetRequest> queryFacetList;
    ExpressionRequest expression;
    FieldFacetRequest fieldFacet;
    int limit;
    int minCount;
    boolean showMissing;
    FieldFacetRequest.FacetSortSpecification sortSpecification;
    RangeFacetRequest rangeFacet;
    boolean hardend;
    List<String> gaps;
    EnumSet<FacetParams.FacetRangeInclude> includeBoundaries;
    EnumSet<FacetParams.FacetRangeOther> otherRanges;
    String queryName;
    List<String> queries;

    public AnalyticsContentHandler(IndexSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.currentElementText = "";
        if (this.inEnvelope) {
            if (this.inRequest) {
                if (localName.equals("statistic")) {
                    this.inStatistic = true;
                } else if (this.inFieldFacet) {
                    if (localName.equals("sortSpecification")) {
                        this.inSortSpecification = true;
                        this.sortSpecification = new FieldFacetRequest.FacetSortSpecification();
                    }
                } else if (localName.equals("fieldFacet")) {
                    String att = atts.getValue(uri, "limit");
                    this.limit = att != null ? Integer.parseInt(att) : -1;
                    att = atts.getValue(uri, "minCount");
                    this.minCount = att != null ? Integer.parseInt(att) : 0;
                    att = atts.getValue(uri, "showMissing");
                    this.showMissing = att != null ? Boolean.parseBoolean(att) : false;
                    this.inFieldFacet = true;
                } else if (localName.equals("rangeFacet")) {
                    String att = atts.getValue(uri, "hardend");
                    this.hardend = att != null ? Boolean.parseBoolean(att) : false;
                    this.gaps = new ArrayList<String>();
                    this.includeBoundaries = EnumSet.noneOf(FacetParams.FacetRangeInclude.class);
                    this.otherRanges = EnumSet.noneOf(FacetParams.FacetRangeOther.class);
                    this.inRangeFacet = true;
                } else if (localName.equals("queryFacet")) {
                    this.queries = new ArrayList<String>();
                    this.inQueryFacet = true;
                }
            } else if (localName.equals("analyticsRequest")) {
                this.fieldFacetList = new ArrayList<FieldFacetRequest>();
                this.rangeFacetList = new ArrayList<RangeFacetRequest>();
                this.queryFacetList = new ArrayList<QueryFacetRequest>();
                this.expressionList = new ArrayList<ExpressionRequest>();
                this.inRequest = true;
            }
        } else if (localName.equals("analyticsRequestEnvelope")) {
            this.requests = new ArrayList<AnalyticsRequest>();
            this.inEnvelope = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inEnvelope) {
            if (this.inRequest) {
                if (this.inStatistic) {
                    if (localName.equals("expression")) {
                        this.expression = new ExpressionRequest(this.currentElementText, this.currentElementText);
                    } else if (localName.equals("name")) {
                        this.expression.setName(this.currentElementText);
                    } else if (localName.equals("statistic")) {
                        this.expressionList.add(this.expression);
                        this.inStatistic = false;
                    }
                } else if (this.inFieldFacet) {
                    if (this.inSortSpecification) {
                        if (localName.equals("statName")) {
                            this.sortSpecification.setStatistic(this.currentElementText);
                        } else if (localName.equals("direction")) {
                            this.sortSpecification.setDirection(FieldFacetRequest.FacetSortDirection.fromExternal(this.currentElementText));
                        } else if (localName.equals("sortSpecification")) {
                            this.fieldFacet.setSort(this.sortSpecification);
                            this.inSortSpecification = false;
                        }
                    } else if (localName.equals("field")) {
                        this.fieldFacet = new FieldFacetRequest(this.schema.getField(this.currentElementText));
                    } else if (localName.equals("fieldFacet")) {
                        this.fieldFacet.setLimit(this.limit);
                        this.fieldFacet.showMissing(this.showMissing);
                        this.fieldFacetList.add(this.fieldFacet);
                        this.inFieldFacet = false;
                    }
                } else if (this.inRangeFacet) {
                    if (localName.equals("field")) {
                        this.rangeFacet = new RangeFacetRequest(this.schema.getField(this.currentElementText), "", "", new String[1]);
                    } else if (localName.equals("start")) {
                        this.rangeFacet.setStart(this.currentElementText);
                    } else if (localName.equals("end")) {
                        this.rangeFacet.setEnd(this.currentElementText);
                    } else if (localName.equals("gap")) {
                        this.gaps.add(this.currentElementText);
                    } else if (localName.equals("includeBoundary")) {
                        this.includeBoundaries.add(FacetParams.FacetRangeInclude.get((String)this.currentElementText));
                    } else if (localName.equals("otherRange")) {
                        this.otherRanges.add(FacetParams.FacetRangeOther.get((String)this.currentElementText));
                    } else if (localName.equals("rangeFacet")) {
                        this.rangeFacet.setHardEnd(this.hardend);
                        this.rangeFacet.setGaps(this.gaps.toArray(new String[1]));
                        this.rangeFacet.setInclude(this.includeBoundaries);
                        this.rangeFacet.setOthers(this.otherRanges);
                        this.inRangeFacet = false;
                        this.rangeFacetList.add(this.rangeFacet);
                    }
                } else if (this.inQueryFacet) {
                    if (localName.equals("name")) {
                        this.queryName = this.currentElementText;
                    } else if (localName.equals("query")) {
                        this.queries.add(this.currentElementText);
                    } else if (localName.equals("queryFacet")) {
                        QueryFacetRequest temp = new QueryFacetRequest(this.queryName);
                        temp.setQueries(this.queries);
                        this.queryFacetList.add(temp);
                        this.inQueryFacet = false;
                    }
                } else if (localName.equals("name")) {
                    this.analyticsRequest = new AnalyticsRequest(this.currentElementText);
                } else if (localName.equals("analyticsRequest")) {
                    this.analyticsRequest.setExpressions(this.expressionList);
                    this.analyticsRequest.setFieldFacets(this.fieldFacetList);
                    this.analyticsRequest.setRangeFacets(this.rangeFacetList);
                    this.analyticsRequest.setQueryFacets(this.queryFacetList);
                    this.requests.add(this.analyticsRequest);
                    this.inRequest = false;
                }
            } else if (localName.equals("analyticsRequestEnvelope")) {
                this.inEnvelope = false;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentElementText = this.currentElementText + new String(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public List<AnalyticsRequest> getAnalyticsRequests() {
        return this.requests;
    }
}

