/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.UnicodeUtil;

public final class TokenStreamFromTermVector
extends TokenStream {
    public static final AttributeFactory ATTRIBUTE_FACTORY = AttributeFactory.getStaticImplementation((AttributeFactory)AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, PackedTokenAttributeImpl.class);
    private final Terms vector;
    private final CharTermAttribute termAttribute;
    private final PositionIncrementAttribute positionIncrementAttribute;
    private final int maxStartOffset;
    private OffsetAttribute offsetAttribute;
    private PayloadAttribute payloadAttribute;
    private CharsRefBuilder termCharsBuilder;
    private BytesRefArray payloadsBytesRefArray;
    private BytesRefBuilder spareBytesRefBuilder;
    private TokenLL firstToken = null;
    private TokenLL incrementToken = null;
    private boolean initialized = false;

    public TokenStreamFromTermVector(Terms vector, int maxStartOffset) throws IOException {
        super(ATTRIBUTE_FACTORY);
        int n = this.maxStartOffset = maxStartOffset < 0 ? Integer.MAX_VALUE : maxStartOffset;
        assert (!this.hasAttribute(PayloadAttribute.class)) : "AttributeFactory shouldn't have payloads *yet*";
        if (!vector.hasPositions() && !vector.hasOffsets()) {
            throw new IllegalArgumentException("The term vector needs positions and/or offsets.");
        }
        assert (vector.hasFreqs());
        this.vector = vector;
        this.termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.positionIncrementAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    }

    public Terms getTermVectorTerms() {
        return this.vector;
    }

    public void reset() throws IOException {
        this.incrementToken = null;
        super.reset();
    }

    private void init() throws IOException {
        BytesRef termBytesRef;
        assert (!this.initialized);
        int dpEnumFlags = 24;
        if (this.vector.hasOffsets()) {
            dpEnumFlags = (short)(dpEnumFlags | 0x38);
            this.offsetAttribute = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        }
        if (this.vector.hasPayloads() && this.hasAttribute(PayloadAttribute.class)) {
            dpEnumFlags = (short)(dpEnumFlags | 0x78);
            this.payloadAttribute = (PayloadAttribute)this.getAttribute(PayloadAttribute.class);
            this.payloadsBytesRefArray = new BytesRefArray(Counter.newCounter());
            this.spareBytesRefBuilder = new BytesRefBuilder();
        }
        this.termCharsBuilder = new CharsRefBuilder();
        this.termCharsBuilder.grow((int)(this.vector.size() * 7L));
        TokenLL[] positionedTokens = this.initTokensArray();
        int lastPosition = -1;
        TermsEnum termsEnum = this.vector.iterator();
        PostingsEnum dpEnum = null;
        CharsRefBuilder tempCharsRefBuilder = new CharsRefBuilder();
        while ((termBytesRef = termsEnum.next()) != null) {
            tempCharsRefBuilder.grow(termBytesRef.length);
            int termCharsLen = UnicodeUtil.UTF8toUTF16((BytesRef)termBytesRef, (char[])tempCharsRefBuilder.chars());
            int termCharsOff = this.termCharsBuilder.length();
            this.termCharsBuilder.append(tempCharsRefBuilder.chars(), 0, termCharsLen);
            dpEnum = termsEnum.postings(null, dpEnum, dpEnumFlags);
            assert (dpEnum != null);
            dpEnum.nextDoc();
            int freq = dpEnum.freq();
            for (int j = 0; j < freq; ++j) {
                int pos = dpEnum.nextPosition();
                TokenLL token = new TokenLL();
                token.termCharsOff = termCharsOff;
                token.termCharsLen = (short)Math.min(termCharsLen, Short.MAX_VALUE);
                if (this.offsetAttribute != null) {
                    token.startOffset = dpEnum.startOffset();
                    if (token.startOffset > this.maxStartOffset) continue;
                    token.endOffsetInc = (short)Math.min(dpEnum.endOffset() - token.startOffset, Short.MAX_VALUE);
                    if (pos == -1) {
                        pos = token.startOffset >> 3;
                    }
                }
                if (this.payloadAttribute != null) {
                    BytesRef payload = dpEnum.getPayload();
                    int n = token.payloadIndex = payload == null ? -1 : this.payloadsBytesRefArray.append(payload);
                }
                if (positionedTokens.length <= pos) {
                    TokenLL[] newPositionedTokens = new TokenLL[(int)((float)(pos + 1) * 1.5f)];
                    System.arraycopy(positionedTokens, 0, newPositionedTokens, 0, lastPosition + 1);
                    positionedTokens = newPositionedTokens;
                }
                positionedTokens[pos] = token.insertIntoSortedLinkedList(positionedTokens[pos]);
                lastPosition = Math.max(lastPosition, pos);
            }
        }
        int prevTokenPos = -1;
        TokenLL prevToken = null;
        for (int pos = 0; pos <= lastPosition; ++pos) {
            TokenLL token = positionedTokens[pos];
            if (token == null) continue;
            if (prevToken != null) {
                assert (prevToken.next == null);
                prevToken.next = token;
            } else {
                assert (this.firstToken == null);
                this.firstToken = token;
            }
            if (this.vector.hasPositions()) {
                token.positionIncrement = pos - prevTokenPos;
                while (token.next != null) {
                    token = token.next;
                    token.positionIncrement = 0;
                }
            } else {
                token.positionIncrement = 1;
                while (token.next != null) {
                    prevToken = token;
                    token = token.next;
                    if (prevToken.startOffset == token.startOffset) {
                        token.positionIncrement = 0;
                        continue;
                    }
                    token.positionIncrement = 1;
                }
            }
            prevTokenPos = pos;
            prevToken = token;
        }
        this.initialized = true;
    }

    private TokenLL[] initTokensArray() throws IOException {
        int sumTotalTermFreq = (int)this.vector.getSumTotalTermFreq();
        if (sumTotalTermFreq == -1) {
            int size = (int)this.vector.size();
            if (size == -1) {
                size = 128;
            }
            sumTotalTermFreq = (int)((double)size * 2.4);
        }
        int originalPositionEstimate = (int)((double)sumTotalTermFreq * 1.5);
        int offsetLimitPositionEstimate = (int)((double)this.maxStartOffset / 5.0);
        return new TokenLL[Math.max(64, Math.min(originalPositionEstimate, offsetLimitPositionEstimate))];
    }

    public boolean incrementToken() throws IOException {
        if (this.incrementToken == null) {
            if (!this.initialized) {
                this.init();
                assert (this.initialized);
            }
            this.incrementToken = this.firstToken;
            if (this.incrementToken == null) {
                return false;
            }
        } else if (this.incrementToken.next != null) {
            this.incrementToken = this.incrementToken.next;
        } else {
            return false;
        }
        this.clearAttributes();
        this.termAttribute.copyBuffer(this.termCharsBuilder.chars(), this.incrementToken.termCharsOff, (int)this.incrementToken.termCharsLen);
        this.positionIncrementAttribute.setPositionIncrement(this.incrementToken.positionIncrement);
        if (this.offsetAttribute != null) {
            this.offsetAttribute.setOffset(this.incrementToken.startOffset, this.incrementToken.startOffset + this.incrementToken.endOffsetInc);
        }
        if (this.payloadAttribute != null) {
            if (this.incrementToken.payloadIndex == -1) {
                this.payloadAttribute.setPayload(null);
            } else {
                this.payloadAttribute.setPayload(this.payloadsBytesRefArray.get(this.spareBytesRefBuilder, this.incrementToken.payloadIndex));
            }
        }
        return true;
    }

    private static class TokenLL {
        int termCharsOff;
        short termCharsLen;
        int positionIncrement;
        int startOffset;
        short endOffsetInc;
        int payloadIndex;
        TokenLL next;

        private TokenLL() {
        }

        TokenLL insertIntoSortedLinkedList(TokenLL head) {
            assert (this.next == null);
            if (head == null) {
                return this;
            }
            if (this.compareOffsets(head) <= 0) {
                this.next = head;
                return this;
            }
            TokenLL prev = head;
            while (prev.next != null && this.compareOffsets(prev.next) > 0) {
                prev = prev.next;
            }
            this.next = prev.next;
            prev.next = this;
            return head;
        }

        int compareOffsets(TokenLL tokenB) {
            int cmp = Integer.compare(this.startOffset, tokenB.startOffset);
            if (cmp == 0) {
                cmp = Short.compare(this.endOffsetInc, tokenB.endOffsetInc);
            }
            return cmp;
        }
    }
}

