/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessorFCBase;
import org.apache.solr.search.facet.FieldUtil;

class FacetFieldProcessorFC
extends FacetFieldProcessorFCBase {
    SortedDocValues sortedDocValues;

    public FacetFieldProcessorFC(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.sortedDocValues.lookupOrd(ord);
    }

    @Override
    protected void findStartAndEndOrds() throws IOException {
        this.sortedDocValues = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.sf, null);
        if (this.prefixRef != null) {
            this.startTermIndex = this.sortedDocValues.lookupTerm(this.prefixRef.get());
            if (this.startTermIndex < 0) {
                this.startTermIndex = -this.startTermIndex - 1;
            }
            this.prefixRef.append(UnicodeUtil.BIG_TERM);
            this.endTermIndex = this.sortedDocValues.lookupTerm(this.prefixRef.get());
            assert (this.endTermIndex < 0);
            this.endTermIndex = -this.endTermIndex - 1;
        } else {
            this.startTermIndex = 0;
            this.endTermIndex = this.sortedDocValues.getValueCount();
        }
        this.startTermIndex = this.startTermIndex == 0 && ((FacetField)this.freq).missing ? -1 : this.startTermIndex;
        this.nTerms = this.endTermIndex - this.startTermIndex;
    }

    @Override
    protected void collectDocs() throws IOException {
        List leaves = this.fcontext.searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        int segBase = 0;
        int adjustedMax = 0;
        DocIterator docsIt = this.fcontext.base.iterator();
        while (docsIt.hasNext()) {
            int term;
            int arrIdx;
            int doc = docsIt.nextDoc();
            if (doc >= adjustedMax) {
                int segMax;
                while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = (ctx = (LeafReaderContext)ctxIt.next()).reader().maxDoc()))) {
                }
                assert (doc >= ctx.docBase);
                this.setNextReader(ctx);
            }
            if ((arrIdx = (term = this.sortedDocValues.getOrd(doc)) - this.startTermIndex) < 0 || arrIdx >= this.nTerms) continue;
            this.countAcc.incrementCount(arrIdx, 1);
            this.collect(doc - segBase, arrIdx);
            if (this.allBucketsSlot < 0 || term < 0) continue;
            this.countAcc.incrementCount(this.allBucketsSlot, 1);
            this.collect(doc - segBase, this.allBucketsSlot);
        }
    }
}

