/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.store.blockcache.Metrics;
import org.apache.solr.store.blockcache.Store;

public class BufferStore
implements Store {
    private static final Store EMPTY = new Store(){

        @Override
        public byte[] takeBuffer(int bufferSize) {
            return new byte[bufferSize];
        }

        @Override
        public void putBuffer(byte[] buffer) {
        }
    };
    private static final ConcurrentMap<Integer, BufferStore> bufferStores = new ConcurrentHashMap<Integer, BufferStore>();
    private final BlockingQueue<byte[]> buffers;
    private final int bufferSize;
    private final AtomicLong shardBuffercacheAllocate;
    private final AtomicLong shardBuffercacheLost;

    public static synchronized void initNewBuffer(int bufferSize, long totalAmount) {
        BufferStore.initNewBuffer(bufferSize, totalAmount, null);
    }

    public static synchronized void initNewBuffer(int bufferSize, long totalAmount, Metrics metrics) {
        if (totalAmount == 0L) {
            return;
        }
        BufferStore bufferStore = (BufferStore)bufferStores.get(bufferSize);
        if (bufferStore == null) {
            long count = totalAmount / (long)bufferSize;
            if (count > Integer.MAX_VALUE) {
                count = Integer.MAX_VALUE;
            }
            AtomicLong shardBuffercacheLost = new AtomicLong(0L);
            AtomicLong shardBuffercacheAllocate = new AtomicLong(0L);
            if (metrics != null) {
                shardBuffercacheLost = metrics.shardBuffercacheLost;
                shardBuffercacheAllocate = metrics.shardBuffercacheAllocate;
            }
            BufferStore store = new BufferStore(bufferSize, (int)count, shardBuffercacheAllocate, shardBuffercacheLost);
            bufferStores.put(bufferSize, store);
        }
    }

    private BufferStore(int bufferSize, int count, AtomicLong shardBuffercacheAllocate, AtomicLong shardBuffercacheLost) {
        this.bufferSize = bufferSize;
        this.shardBuffercacheAllocate = shardBuffercacheAllocate;
        this.shardBuffercacheLost = shardBuffercacheLost;
        this.buffers = BufferStore.setupBuffers(bufferSize, count);
    }

    private static BlockingQueue<byte[]> setupBuffers(int bufferSize, int count) {
        ArrayBlockingQueue<byte[]> queue = new ArrayBlockingQueue<byte[]>(count);
        for (int i = 0; i < count; ++i) {
            queue.add(new byte[bufferSize]);
        }
        return queue;
    }

    public static Store instance(int bufferSize) {
        BufferStore bufferStore = (BufferStore)bufferStores.get(bufferSize);
        if (bufferStore == null) {
            return EMPTY;
        }
        return bufferStore;
    }

    @Override
    public byte[] takeBuffer(int bufferSize) {
        if (this.bufferSize != bufferSize) {
            throw new RuntimeException("Buffer with length [" + bufferSize + "] does not match buffer size of [" + bufferSize + "]");
        }
        return this.newBuffer((byte[])this.buffers.poll());
    }

    @Override
    public void putBuffer(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.length != this.bufferSize) {
            throw new RuntimeException("Buffer with length [" + buffer.length + "] does not match buffer size of [" + this.bufferSize + "]");
        }
        this.checkReturn(this.buffers.offer(buffer));
    }

    private void checkReturn(boolean accepted) {
        if (!accepted) {
            this.shardBuffercacheLost.incrementAndGet();
        }
    }

    private byte[] newBuffer(byte[] buf) {
        if (buf != null) {
            return buf;
        }
        this.shardBuffercacheAllocate.incrementAndGet();
        return new byte[this.bufferSize];
    }
}

