/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ManagementObject;
import org.apache.uima.util.Level;

public class JmxMBeanAgent {
    private static Class mbeanServerClass;
    private static Class objectNameClass;
    private static Constructor objectNameConstructor;
    private static Method isRegistered;
    private static Method registerMBean;
    private static Method unregisterMBean;
    private static boolean jmxAvailable;
    private static Object platformMBeanServer;
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMBean(ManagementObject aMBean, Object aMBeanServer) {
        if (!jmxAvailable) {
            return;
        }
        if (aMBeanServer == null) {
            if (platformMBeanServer != null) {
                aMBeanServer = platformMBeanServer;
            } else {
                UIMAFramework.getLogger().logrb(Level.CONFIG, JmxMBeanAgent.class.getName(), "registerMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_platform_mbean_server_not_available__CONFIG");
                return;
            }
        }
        try {
            Object mbeanName = objectNameConstructor.newInstance(aMBean.getUniqueMBeanName());
            Object object = aMBeanServer;
            synchronized (object) {
                if (!((Boolean)isRegistered.invoke(aMBeanServer, mbeanName)).booleanValue()) {
                    registerMBean.invoke(aMBeanServer, aMBean, mbeanName);
                }
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger().logrb(Level.WARNING, JmxMBeanAgent.class.getName(), "registerMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_failed_to_register_mbean__WARNING", e);
            return;
        }
    }

    public static void unregisterMBean(ManagementObject aMBean, Object aMBeanServer) {
        if (!jmxAvailable) {
            return;
        }
        if (aMBeanServer == null) {
            if (platformMBeanServer != null) {
                aMBeanServer = platformMBeanServer;
            } else {
                UIMAFramework.getLogger().logrb(Level.CONFIG, JmxMBeanAgent.class.getName(), "unregisterMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_platform_mbean_server_not_available__CONFIG");
                return;
            }
        }
        try {
            String mbeanName = aMBean.getUniqueMBeanName();
            if (mbeanName != null) {
                Object objName = objectNameConstructor.newInstance(mbeanName);
                if (((Boolean)isRegistered.invoke(aMBeanServer, objName)).booleanValue()) {
                    unregisterMBean.invoke(aMBeanServer, objName);
                }
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger().logrb(Level.WARNING, JmxMBeanAgent.class.getName(), "unregisterMBean", LOG_RESOURCE_BUNDLE, "UIMA_JMX_failed_to_unregister_mbean__WARNING", e);
            return;
        }
    }

    static {
        try {
            mbeanServerClass = Class.forName("javax.management.MBeanServer");
            objectNameClass = Class.forName("javax.management.ObjectName");
            objectNameConstructor = objectNameClass.getConstructor(String.class);
            isRegistered = mbeanServerClass.getMethod("isRegistered", objectNameClass);
            registerMBean = mbeanServerClass.getMethod("registerMBean", Object.class, objectNameClass);
            unregisterMBean = mbeanServerClass.getMethod("unregisterMBean", objectNameClass);
            jmxAvailable = true;
        }
        catch (Exception e) {
            jmxAvailable = false;
        }
        try {
            Class<?> managementFactory = Class.forName("java.lang.management.ManagementFactory");
            Method getPlatformMBeanServer = managementFactory.getMethod("getPlatformMBeanServer", new Class[0]);
            platformMBeanServer = getPlatformMBeanServer.invoke(null, null);
        }
        catch (Exception e) {
            platformMBeanServer = null;
        }
    }
}

