/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectUtil {
    public static void mergeObjects(Map<String, Object> top, List<String> path, Object val, ConflictHandler handler) {
        String key;
        LinkedHashMap<String, Object> outer = top;
        for (int i = 0; i < path.size() - 1; ++i) {
            LinkedHashMap<String, Object> sub = (LinkedHashMap<String, Object>)outer.get(path.get(i));
            if (sub == null) {
                sub = new LinkedHashMap<String, Object>();
                outer.put(path.get(i), sub);
            }
            outer = sub;
        }
        String string = key = path.size() > 0 ? path.get(path.size() - 1) : null;
        if (key != null) {
            Object existingVal = outer.put(key, val);
            if (existingVal != null) {
                handler.handleConflict(outer, path, key, val, existingVal);
            }
        } else {
            Map newMap = (Map)val;
            handler.mergeMap(outer, newMap, path);
        }
    }

    public static class ConflictHandler {
        protected boolean isList(Map<String, Object> container, List<String> path, String key, Object current, Object previous) {
            return key != null && ("fields".equals(key) || "filter".equals(key));
        }

        public void handleConflict(Map<String, Object> container, List<String> path, String key, Object current, Object previous) {
            boolean handleAsList = this.isList(container, path, key, current, previous);
            if (handleAsList) {
                container.put(key, this.makeList(current, previous));
                return;
            }
            if (previous instanceof Map && current instanceof Map) {
                Map prevMap = (Map)previous;
                Map currMap = (Map)current;
                if (prevMap.size() == 0) {
                    return;
                }
                this.mergeMap(prevMap, currMap, path);
                container.put(key, prevMap);
                return;
            }
        }

        public void mergeMap(Map<String, Object> targetMap, Map<String, Object> srcMap, List<String> path) {
            if (srcMap.size() == 0) {
                return;
            }
            for (Map.Entry<String, Object> srcEntry : srcMap.entrySet()) {
                Object subVal;
                String subKey = srcEntry.getKey();
                Object subPrev = targetMap.put(subKey, subVal = srcEntry.getValue());
                if (subPrev == null) continue;
                path.add(subKey);
                this.handleConflict(targetMap, path, subKey, subVal, subPrev);
                path.remove(path.size() - 1);
            }
        }

        protected Object makeList(Object current, Object previous) {
            ArrayList lst = new ArrayList();
            this.append(lst, previous);
            this.append(lst, current);
            return lst;
        }

        protected void append(List lst, Object current) {
            if (current instanceof Collection) {
                lst.addAll((Collection)current);
            } else {
                lst.add(current);
            }
        }
    }
}

