/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoNorthLatitudeZone
extends GeoBBoxBase {
    public final double bottomLat;
    public final double cosBottomLat;
    public final SidedPlane bottomPlane;
    public final GeoPoint interiorPoint;
    public static final GeoPoint[] planePoints = new GeoPoint[0];
    public final GeoPoint bottomBoundaryPoint;
    public final GeoPoint[] edgePoints;

    public GeoNorthLatitudeZone(double bottomLat) {
        this.bottomLat = bottomLat;
        double sinBottomLat = Math.sin(bottomLat);
        this.cosBottomLat = Math.cos(bottomLat);
        Vector bottomPoint = new Vector(0.0, 0.0, sinBottomLat);
        double middleLat = (1.5707963267948966 + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.interiorPoint = new GeoPoint(Math.sqrt(1.0 - sinMiddleLat * sinMiddleLat), 0.0, sinMiddleLat);
        this.bottomBoundaryPoint = new GeoPoint(Math.sqrt(1.0 - sinBottomLat * sinBottomLat), 0.0, sinBottomLat);
        this.bottomPlane = new SidedPlane((Vector)this.interiorPoint, sinBottomLat);
        this.edgePoints = new GeoPoint[]{this.bottomBoundaryPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = 1.5707963267948966;
        double newBottomLat = this.bottomLat - angle;
        return GeoBBoxFactory.makeGeoBBox(1.5707963267948966, newBottomLat, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.bottomPlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.bottomPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        if (this.bottomLat < 0.0) {
            return Math.PI;
        }
        double maxCosLat = this.cosBottomLat;
        return maxCosLat * Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.bottomPlane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noLongitudeBound().noTopLatitudeBound().addLatitudeZone(this.bottomLat);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path.isWithin(this.bottomBoundaryPoint);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.bottomPlane, planePoints, new Membership[0])) {
            return 2;
        }
        if (insideShape) {
            return 0;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoNorthLatitudeZone)) {
            return false;
        }
        GeoNorthLatitudeZone other = (GeoNorthLatitudeZone)o;
        return other.bottomPlane.equals(this.bottomPlane);
    }

    public int hashCode() {
        int result = this.bottomPlane.hashCode();
        return result;
    }

    public String toString() {
        return "GeoNorthLatitudeZone: {bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + ")}";
    }
}

